/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.rcfile.ColumnData;
import io.trino.rcfile.EncodeOutput;
import io.trino.rcfile.RcFileDecoderUtils;
import io.trino.rcfile.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class StringEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final Byte escapeByte;

    public StringEncoding(Type type, Slice nullSequence, Byte escapeChar) {
        this.type = type;
        this.nullSequence = nullSequence;
        this.escapeByte = escapeChar;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                Slice slice = this.type.getSlice(block, position);
                if (this.escapeByte != null && slice.indexOfByte(this.escapeByte.byteValue()) < 0) {
                    throw new IllegalArgumentException("escape not implemented");
                }
                output.writeBytes(slice);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        if (this.escapeByte != null && slice.indexOfByte(this.escapeByte.byteValue()) < 0) {
            throw new IllegalArgumentException("escape not implemented");
        }
        output.writeBytes(slice);
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        if (this.escapeByte != null) {
            columnData = StringEncoding.unescape(columnData, this.escapeByte);
        }
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            length = RcFileDecoderUtils.calculateTruncationLength(this.type, slice, offset, length);
            this.type.writeSlice(builder, slice, offset, length);
        }
        return builder.build();
    }

    private static ColumnData unescape(ColumnData columnData, byte escapeByte) {
        Slice slice = columnData.getSlice();
        if (slice.indexOfByte(escapeByte) < 0) {
            return columnData;
        }
        Slice newSlice = Slices.allocate((int)slice.length());
        SliceOutput output = newSlice.getOutput();
        int[] newOffsets = new int[columnData.rowCount() + 1];
        for (int row = 0; row < columnData.rowCount(); ++row) {
            int offset = columnData.getOffset(row);
            int length = columnData.getLength(row);
            for (int i = 0; i < length; ++i) {
                byte value = slice.getByte(offset + i);
                if (value == escapeByte && i + 1 < length) {
                    value = slice.getByte(offset + ++i);
                }
                output.write((int)value);
            }
            newOffsets[row + 1] = output.size();
        }
        return new ColumnData(newOffsets, output.slice());
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        length = RcFileDecoderUtils.calculateTruncationLength(this.type, slice, offset, length);
        this.type.writeSlice(builder, slice, offset, length);
    }
}

