/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.binary;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.rcfile.binary.BinaryColumnEncoding;
import io.trino.rcfile.binary.BlockEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.List;

public class StructEncoding
extends BlockEncoding {
    private final List<BinaryColumnEncoding> structFields;

    public StructEncoding(Type type, List<BinaryColumnEncoding> structFields) {
        super(type);
        this.structFields = ImmutableList.copyOf(structFields);
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        Block row = (Block)block.getObject(position, Block.class);
        for (int batchStart = 0; batchStart < row.getPositionCount(); batchStart += 8) {
            int fieldId;
            int batchEnd = Math.min(batchStart + 8, this.structFields.size());
            int nullByte = 0;
            for (fieldId = batchStart; fieldId < batchEnd; ++fieldId) {
                if (row.isNull(fieldId)) continue;
                nullByte |= 1 << fieldId % 8;
            }
            output.writeByte(nullByte);
            for (fieldId = batchStart; fieldId < batchEnd; ++fieldId) {
                if (row.isNull(fieldId)) continue;
                BinaryColumnEncoding field = this.structFields.get(fieldId);
                field.encodeValueInto(row, fieldId, output);
            }
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        int fieldId;
        byte nullByte = 0;
        int elementOffset = offset;
        BlockBuilder rowBuilder = builder.beginBlockEntry();
        for (fieldId = 0; fieldId < this.structFields.size() && elementOffset < offset + length; ++fieldId) {
            BinaryColumnEncoding field = this.structFields.get(fieldId);
            if (fieldId % 8 == 0) {
                nullByte = slice.getByte(elementOffset);
                ++elementOffset;
            }
            if ((nullByte & 1 << fieldId % 8) != 0) {
                int valueOffset = field.getValueOffset(slice, elementOffset);
                int valueLength = field.getValueLength(slice, elementOffset);
                field.decodeValueInto(rowBuilder, slice, elementOffset + valueOffset, valueLength);
                elementOffset = elementOffset + valueOffset + valueLength;
                continue;
            }
            rowBuilder.appendNull();
        }
        while (fieldId < this.structFields.size()) {
            rowBuilder.appendNull();
            ++fieldId;
        }
        builder.closeEntry();
    }
}

