/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.binary;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.rcfile.ColumnData;
import io.trino.rcfile.EncodeOutput;
import io.trino.rcfile.binary.BinaryColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class ShortEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public ShortEncoding(Type type) {
        this.type = type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                output.writeShort((int)Short.reverseBytes((short)this.type.getLong(block, position)));
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        output.writeShort((int)Short.reverseBytes((short)this.type.getLong(block, position)));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                Preconditions.checkState((length == 2 ? 1 : 0) != 0, (Object)"Short should be 2 bytes");
                this.type.writeLong(builder, (long)Short.reverseBytes(slice.getShort(columnData.getOffset(i))));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return 2;
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeLong(builder, (long)Short.reverseBytes(slice.getShort(offset)));
    }
}

