/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile;

import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.BiFunction;

public final class TimestampHolder {
    private final long seconds;
    private final int nanosOfSecond;

    public TimestampHolder(long epochMicros, int picosOfMicro) {
        this.seconds = Math.floorDiv(epochMicros, 1000000);
        long picosOfSecond = (long)Math.floorMod(epochMicros, 1000000) * 1000000L + (long)picosOfMicro;
        this.nanosOfSecond = Math.toIntExact(picosOfSecond / 1000L);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanosOfSecond() {
        return this.nanosOfSecond;
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(this.seconds, this.nanosOfSecond, ZoneOffset.UTC);
    }

    public static BiFunction<Block, Integer, TimestampHolder> getFactory(TimestampType type) {
        if (type.isShort()) {
            return (block, position) -> new TimestampHolder(type.getLong(block, position.intValue()), 0);
        }
        return (block, position) -> {
            LongTimestamp longTimestamp = (LongTimestamp)type.getObject(block, position.intValue());
            return new TimestampHolder(longTimestamp.getEpochMicros(), longTimestamp.getPicosOfMicro());
        };
    }
}

