/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(HostsFileReader.class);
    private final AtomicReference<HostDetails> current;

    public HostsFileReader(String inFile, String exFile) throws IOException {
        HostDetails hostDetails = new HostDetails(inFile, Collections.emptySet(), exFile, Collections.emptyMap());
        this.current = new AtomicReference<HostDetails>(hostDetails);
        this.refresh(inFile, exFile);
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        HostDetails hostDetails = new HostDetails(includesFile, Collections.emptySet(), excludesFile, Collections.emptyMap());
        this.current = new AtomicReference<HostDetails>(hostDetails);
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, StandardCharsets.UTF_8));
            block3: while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = nodes[i].trim();
                    if (nodes[i].startsWith("#")) continue block3;
                    if (nodes[i].isEmpty()) continue;
                    LOG.info("Adding a node \"" + nodes[i] + "\" to the list of " + type + " hosts from " + filename);
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public void refresh() throws IOException {
        HostDetails hostDetails = this.current.get();
        this.refresh(hostDetails.includesFile, hostDetails.excludesFile);
    }

    public static void readFileToMap(String type, String filename, Map<String, Integer> map) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToMapWithFileInputStream(type, filename, fis, map);
    }

    public static void readFileToMapWithFileInputStream(String type, String filename, InputStream inputStream, Map<String, Integer> map) throws IOException {
        boolean xmlInput = filename.toLowerCase().endsWith(".xml");
        if (xmlInput) {
            HostsFileReader.readXmlFileToMapWithFileInputStream(type, filename, inputStream, map);
        } else {
            HashSet<String> nodes = new HashSet<String>();
            HostsFileReader.readFileToSetWithFileInputStream(type, filename, inputStream, nodes);
            for (String node : nodes) {
                map.put(node, null);
            }
        }
    }

    public static void readXmlFileToMapWithFileInputStream(String type, String filename, InputStream fileInputStream, Map<String, Integer> map) throws IOException {
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = builder.newDocumentBuilder();
            Document dom = db.parse(fileInputStream);
            Element doc = dom.getDocumentElement();
            NodeList nodes = doc.getElementsByTagName("host");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                String v = HostsFileReader.readFirstTagValue(e, "name");
                String[] hosts = StringUtils.getTrimmedStrings(v);
                String str = HostsFileReader.readFirstTagValue(e, "timeout");
                Integer timeout = str == null ? null : Integer.valueOf(Integer.parseInt(str));
                for (String host : hosts) {
                    map.put(host, timeout);
                    LOG.info("Adding a node \"" + host + "\" to the list of " + type + " hosts from " + filename);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("error parsing " + filename, e);
            throw new RuntimeException(e);
        }
        finally {
            fileInputStream.close();
        }
    }

    static String readFirstTagValue(Element e, String tag) {
        NodeList nodes = e.getElementsByTagName(tag);
        return nodes.getLength() == 0 ? null : nodes.item(0).getTextContent();
    }

    public void refresh(String includesFile, String excludesFile) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HostDetails oldDetails = this.current.get();
        Set<String> newIncludes = oldDetails.includes;
        Map<String, Integer> newExcludes = oldDetails.excludes;
        if (includesFile != null && !includesFile.isEmpty()) {
            newIncludes = new HashSet<String>();
            HostsFileReader.readFileToSet("included", includesFile, newIncludes);
            newIncludes = Collections.unmodifiableSet(newIncludes);
        }
        if (excludesFile != null && !excludesFile.isEmpty()) {
            newExcludes = new HashMap<String, Integer>();
            HostsFileReader.readFileToMap("excluded", excludesFile, newExcludes);
            newExcludes = Collections.unmodifiableMap(newExcludes);
        }
        HostDetails newDetails = new HostDetails(includesFile, newIncludes, excludesFile, newExcludes);
        this.current.set(newDetails);
    }

    @InterfaceAudience.Private
    public void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HostDetails oldDetails = this.current.get();
        Set<String> newIncludes = oldDetails.includes;
        Map<String, Integer> newExcludes = oldDetails.excludes;
        if (inFileInputStream != null) {
            newIncludes = new HashSet<String>();
            HostsFileReader.readFileToSetWithFileInputStream("included", oldDetails.includesFile, inFileInputStream, newIncludes);
            newIncludes = Collections.unmodifiableSet(newIncludes);
        }
        if (exFileInputStream != null) {
            newExcludes = new HashMap<String, Integer>();
            HostsFileReader.readFileToMapWithFileInputStream("excluded", oldDetails.excludesFile, exFileInputStream, newExcludes);
            newExcludes = Collections.unmodifiableMap(newExcludes);
        }
        HostDetails newDetails = new HostDetails(oldDetails.includesFile, newIncludes, oldDetails.excludesFile, newExcludes);
        this.current.set(newDetails);
    }

    public Set<String> getHosts() {
        HostDetails hostDetails = this.current.get();
        return hostDetails.getIncludedHosts();
    }

    public Set<String> getExcludedHosts() {
        HostDetails hostDetails = this.current.get();
        return hostDetails.getExcludedHosts();
    }

    @Deprecated
    public void getHostDetails(Set<String> includes, Set<String> excludes) {
        HostDetails hostDetails = this.current.get();
        includes.addAll(hostDetails.getIncludedHosts());
        excludes.addAll(hostDetails.getExcludedHosts());
    }

    @Deprecated
    public void getHostDetails(Set<String> includeHosts, Map<String, Integer> excludeHosts) {
        HostDetails hostDetails = this.current.get();
        includeHosts.addAll(hostDetails.getIncludedHosts());
        excludeHosts.putAll(hostDetails.getExcludedMap());
    }

    public HostDetails getHostDetails() {
        return this.current.get();
    }

    public void setIncludesFile(String includesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(includesFile, oldDetails.includes, oldDetails.excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public void setExcludesFile(String excludesFile) {
        LOG.info("Setting the excludes file to " + excludesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(oldDetails.includesFile, oldDetails.includes, excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public void updateFileNames(String includesFile, String excludesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        LOG.info("Setting the excludes file to " + excludesFile);
        HostDetails oldDetails = this.current.get();
        HostDetails newDetails = new HostDetails(includesFile, oldDetails.includes, excludesFile, oldDetails.excludes);
        this.current.set(newDetails);
    }

    public static class HostDetails {
        private final String includesFile;
        private final Set<String> includes;
        private final String excludesFile;
        private final Map<String, Integer> excludes;

        HostDetails(String includesFile, Set<String> includes, String excludesFile, Map<String, Integer> excludes) {
            this.includesFile = includesFile;
            this.includes = includes;
            this.excludesFile = excludesFile;
            this.excludes = excludes;
        }

        public String getIncludesFile() {
            return this.includesFile;
        }

        public Set<String> getIncludedHosts() {
            return this.includes;
        }

        public String getExcludesFile() {
            return this.excludesFile;
        }

        public Set<String> getExcludedHosts() {
            return this.excludes.keySet();
        }

        public Map<String, Integer> getExcludedMap() {
            return this.excludes;
        }
    }
}

