/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import io.trino.hadoop.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

public final class DtFileOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DtFileOperations.class);
    public static final String FORMAT_PB = "protobuf";
    public static final String FORMAT_JAVA = "java";
    private static final String NA_STRING = "-NA-";
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";

    private DtFileOperations() {
    }

    private static String stripPrefix(String u) {
        return u.replaceFirst(PREFIX_HTTP, "").replaceFirst(PREFIX_HTTPS, "");
    }

    private static boolean matchAlias(Token<?> token, Text alias) {
        return alias == null || token.getService().equals(alias);
    }

    private static boolean matchService(DtFetcher fetcher, Text service, String url) {
        Text sName = fetcher.getServiceName();
        return service == null && url.startsWith(sName.toString() + "://") || service != null && service.equals(sName);
    }

    private static String formatDate(long date) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(new Date(date));
    }

    private static Path fileToPath(File f) {
        return new Path("file:" + f.getAbsolutePath());
    }

    public static void doFormattedWrite(File f, String format, Credentials creds, Configuration conf) throws IOException {
        Credentials.SerializedFormat credsFormat = Credentials.SerializedFormat.WRITABLE;
        if (format.equals(FORMAT_PB)) {
            credsFormat = Credentials.SerializedFormat.PROTOBUF;
        }
        creds.writeTokenStorageFile(DtFileOperations.fileToPath(f), conf, credsFormat);
    }

    public static void printTokenFile(File tokenFile, Text alias, Configuration conf, PrintStream out) throws IOException {
        out.println("File: " + tokenFile.getPath());
        Credentials creds = Credentials.readTokenStorageFile(tokenFile, conf);
        DtFileOperations.printCredentials(creds, alias, out);
    }

    public static void printCredentials(Credentials creds, Text alias, PrintStream out) throws IOException {
        boolean tokenHeader = true;
        String fmt = "%-24s %-20s %-15s %-12s %s%n";
        for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
            if (!DtFileOperations.matchAlias(token, alias)) continue;
            if (tokenHeader) {
                out.printf(fmt, "Token kind", "Service", "Renewer", "Exp date", "URL enc token");
                out.println(StringUtils.repeat("-", 80));
                tokenHeader = false;
            }
            AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
            out.printf(fmt, token.getKind(), token.getService(), id != null ? id.getRenewer() : NA_STRING, id != null ? DtFileOperations.formatDate(id.getMaxDate()) : NA_STRING, token.encodeToUrlString());
        }
    }

    public static void getTokenFile(File tokenFile, String fileFormat, Text alias, Text service, String url, String renewer, Configuration conf) throws Exception {
        Token<?> token = null;
        Credentials creds = tokenFile.exists() ? Credentials.readTokenStorageFile(tokenFile, conf) : new Credentials();
        ServiceLoader<DtFetcher> loader = ServiceLoader.load(DtFetcher.class);
        for (DtFetcher fetcher : loader) {
            if (!DtFileOperations.matchService(fetcher, service, url)) continue;
            if (!fetcher.isTokenRequired()) {
                String message = "DtFetcher for service '" + service + "' does not require a token.  Check your configuration.  Note: security may be disabled or there may be two DtFetcher providers for the same service designation.";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            token = fetcher.addDelegationTokens(conf, creds, renewer, DtFileOperations.stripPrefix(url));
        }
        if (alias != null) {
            if (token == null) {
                String message = "DtFetcher for service '" + service + "' does not allow aliasing.  Cannot apply alias '" + alias + "'.  Drop alias flag to get token for this service.";
                LOG.error(message);
                throw new IOException(message);
            }
            Token aliasedToken = token.copyToken();
            aliasedToken.setService(alias);
            creds.addToken(alias, aliasedToken);
            LOG.info("Add token with service " + alias);
        }
        DtFileOperations.doFormattedWrite(tokenFile, fileFormat, creds, conf);
    }

    public static void aliasTokenFile(File tokenFile, String fileFormat, Text alias, Text service, Configuration conf) throws Exception {
        Credentials newCreds = new Credentials();
        Credentials creds = Credentials.readTokenStorageFile(tokenFile, conf);
        for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
            newCreds.addToken(token.getService(), token);
            if (!token.getService().equals(service)) continue;
            Token<? extends TokenIdentifier> aliasedToken = token.copyToken();
            aliasedToken.setService(alias);
            newCreds.addToken(alias, aliasedToken);
        }
        DtFileOperations.doFormattedWrite(tokenFile, fileFormat, newCreds, conf);
    }

    public static void appendTokenFiles(ArrayList<File> tokenFiles, String fileFormat, Configuration conf) throws IOException {
        Credentials newCreds = new Credentials();
        File lastTokenFile = null;
        Iterator<File> iterator = tokenFiles.iterator();
        while (iterator.hasNext()) {
            File tokenFile;
            lastTokenFile = tokenFile = iterator.next();
            Credentials creds = Credentials.readTokenStorageFile(tokenFile, conf);
            for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
                newCreds.addToken(token.getService(), token);
            }
        }
        DtFileOperations.doFormattedWrite(lastTokenFile, fileFormat, newCreds, conf);
    }

    public static void removeTokenFromFile(boolean cancel, File tokenFile, String fileFormat, Text alias, Configuration conf) throws IOException, InterruptedException {
        Credentials newCreds = new Credentials();
        Credentials creds = Credentials.readTokenStorageFile(tokenFile, conf);
        for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
            if (DtFileOperations.matchAlias(token, alias)) {
                if (!token.isManaged() || !cancel) continue;
                token.cancel(conf);
                LOG.info("Canceled " + token.getKind() + ":" + token.getService());
                continue;
            }
            newCreds.addToken(token.getService(), token);
        }
        DtFileOperations.doFormattedWrite(tokenFile, fileFormat, newCreds, conf);
    }

    public static void renewTokenFile(File tokenFile, String fileFormat, Text alias, Configuration conf) throws IOException, InterruptedException {
        Credentials creds = Credentials.readTokenStorageFile(tokenFile, conf);
        for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
            if (!token.isManaged() || !DtFileOperations.matchAlias(token, alias)) continue;
            long result = token.renew(conf);
            LOG.info("Renewed" + token.getKind() + ":" + token.getService() + " until " + DtFileOperations.formatDate(result));
        }
        DtFileOperations.doFormattedWrite(tokenFile, fileFormat, creds, conf);
    }
}

