/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;

public final class UserGroupInformationShim {
    private UserGroupInformationShim() {
    }

    public static Subject getSubject(UserGroupInformation userGroupInformation) {
        return userGroupInformation.getSubject();
    }

    public static UserGroupInformation createUserGroupInformationForSubject(Subject subject) {
        Objects.requireNonNull(subject, "subject is null");
        Set<KerberosPrincipal> kerberosPrincipals = subject.getPrincipals(KerberosPrincipal.class);
        if (kerberosPrincipals.isEmpty()) {
            throw new IllegalArgumentException("subject must contain a KerberosPrincipal");
        }
        if (kerberosPrincipals.size() != 1) {
            throw new IllegalArgumentException("subject must contain only a single KerberosPrincipal");
        }
        KerberosPrincipal principal = kerberosPrincipals.iterator().next();
        User user = new User(principal.getName(), UserGroupInformation.AuthenticationMethod.KERBEROS, null);
        subject.getPrincipals().add(user);
        UserGroupInformation userGroupInformation = new UserGroupInformation(subject);
        userGroupInformation.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        return userGroupInformation;
    }
}

