/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.impl.MetricsBuffer;
import org.apache.hadoop.metrics2.impl.MetricsRecordFiltered;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.SinkQueue;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.util.Contracts;
import org.apache.hadoop.util.Time;

class MetricsSinkAdapter
implements SinkQueue.Consumer<MetricsBuffer> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSinkAdapter.class);
    private final String name;
    private final String description;
    private final String context;
    private final MetricsSink sink;
    private final MetricsFilter sourceFilter;
    private final MetricsFilter recordFilter;
    private final MetricsFilter metricFilter;
    private final SinkQueue<MetricsBuffer> queue;
    private final Thread sinkThread;
    private volatile boolean stopping = false;
    private volatile boolean inError = false;
    private final int periodMs;
    private final int firstRetryDelay;
    private final int retryCount;
    private final long oobPutTimeout;
    private final float retryBackoff;
    private final MetricsRegistry registry = new MetricsRegistry("sinkadapter");
    private final MutableStat latency;
    private final MutableCounterInt dropped;
    private final MutableGaugeInt qsize;

    MetricsSinkAdapter(String name, String description, MetricsSink sink, String context, MetricsFilter sourceFilter, MetricsFilter recordFilter, MetricsFilter metricFilter, int periodMs, int queueCapacity, int retryDelay, float retryBackoff, int retryCount) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.sink = Preconditions.checkNotNull(sink, "sink object");
        this.context = context;
        this.sourceFilter = sourceFilter;
        this.recordFilter = recordFilter;
        this.metricFilter = metricFilter;
        this.periodMs = Contracts.checkArg(periodMs, periodMs > 0, (Object)"period");
        this.firstRetryDelay = Contracts.checkArg(retryDelay, retryDelay > 0, (Object)"retry delay");
        this.retryBackoff = Contracts.checkArg(retryBackoff, retryBackoff > 1.0f, (Object)"retry backoff");
        this.oobPutTimeout = (long)((double)this.firstRetryDelay * Math.pow(retryBackoff, retryCount) * 1000.0);
        this.retryCount = retryCount;
        this.queue = new SinkQueue(Contracts.checkArg(queueCapacity, queueCapacity > 0, (Object)"queue capacity"));
        this.latency = this.registry.newRate("Sink_" + name, "Sink end to end latency", false);
        this.dropped = this.registry.newCounter("Sink_" + name + "Dropped", "Dropped updates per sink", 0);
        this.qsize = this.registry.newGauge("Sink_" + name + "Qsize", "Queue size", 0);
        this.sinkThread = new Thread(){

            @Override
            public void run() {
                MetricsSinkAdapter.this.publishMetricsFromQueue();
            }
        };
        this.sinkThread.setName(name);
        this.sinkThread.setDaemon(true);
    }

    boolean putMetrics(MetricsBuffer buffer, long logicalTimeMs) {
        if (logicalTimeMs % (long)this.periodMs == 0L) {
            LOG.debug("enqueue, logicalTime=" + logicalTimeMs);
            if (this.queue.enqueue(buffer)) {
                this.refreshQueueSizeGauge();
                return true;
            }
            this.dropped.incr();
            return false;
        }
        return true;
    }

    public boolean putMetricsImmediate(MetricsBuffer buffer) {
        WaitableMetricsBuffer waitableBuffer = new WaitableMetricsBuffer(buffer);
        if (!this.queue.enqueue(waitableBuffer)) {
            LOG.warn(this.name + " has a full queue and can't consume the given metrics.");
            this.dropped.incr();
            return false;
        }
        this.refreshQueueSizeGauge();
        if (!waitableBuffer.waitTillNotified(this.oobPutTimeout)) {
            LOG.warn(this.name + " couldn't fulfill an immediate putMetrics request in time. Abandoning.");
            return false;
        }
        return true;
    }

    void publishMetricsFromQueue() {
        int retryDelay = this.firstRetryDelay;
        int n = this.retryCount;
        int minDelay = Math.min(500, retryDelay * 1000);
        Random rng = new Random(System.nanoTime());
        while (!this.stopping) {
            try {
                this.queue.consumeAll(this);
                this.refreshQueueSizeGauge();
                retryDelay = this.firstRetryDelay;
                n = this.retryCount;
                this.inError = false;
            }
            catch (InterruptedException e) {
                LOG.info(this.name + " thread interrupted.");
            }
            catch (Exception e) {
                if (n > 0) {
                    int retryWindow = Math.max(0, 500 * retryDelay - minDelay);
                    int awhile = rng.nextInt(retryWindow) + minDelay;
                    if (!this.inError) {
                        LOG.error("Got sink exception, retry in " + awhile + "ms", e);
                    }
                    retryDelay = (int)((float)retryDelay * this.retryBackoff);
                    try {
                        Thread.sleep(awhile);
                    }
                    catch (InterruptedException e2) {
                        LOG.info(this.name + " thread interrupted while waiting for retry", e2);
                    }
                    --n;
                    continue;
                }
                if (!this.inError) {
                    LOG.error("Got sink exception and over retry limit, suppressing further error messages", e);
                }
                this.queue.clear();
                this.refreshQueueSizeGauge();
                this.inError = true;
            }
        }
    }

    private void refreshQueueSizeGauge() {
        this.qsize.set(this.queue.size());
    }

    @Override
    public void consume(MetricsBuffer buffer) {
        long ts = 0L;
        for (MetricsBuffer.Entry entry : buffer) {
            if (this.sourceFilter != null && !this.sourceFilter.accepts(entry.name())) continue;
            for (MetricsRecordImpl record : entry.records()) {
                if (this.context != null && !this.context.equals(record.context()) || this.recordFilter != null && !this.recordFilter.accepts(record)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pushing record " + entry.name() + "." + record.context() + "." + record.name() + " to " + this.name);
                }
                this.sink.putMetrics(this.metricFilter == null ? record : new MetricsRecordFiltered(record, this.metricFilter));
                if (ts != 0L) continue;
                ts = record.timestamp();
            }
        }
        if (ts > 0L) {
            this.sink.flush();
            this.latency.add(Time.now() - ts);
        }
        if (buffer instanceof WaitableMetricsBuffer) {
            ((WaitableMetricsBuffer)buffer).notifyAnyWaiters();
        }
        LOG.debug("Done");
    }

    void start() {
        this.sinkThread.start();
        LOG.info("Sink " + this.name + " started");
    }

    void stop() {
        this.stopping = true;
        this.sinkThread.interrupt();
        if (this.sink instanceof Closeable) {
            IOUtils.cleanupWithLogger(LOG, (Closeable)((Object)this.sink));
        }
        try {
            this.sinkThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Stop interrupted", e);
        }
    }

    String name() {
        return this.name;
    }

    String description() {
        return this.description;
    }

    void snapshot(MetricsRecordBuilder rb, boolean all) {
        this.registry.snapshot(rb, all);
    }

    MetricsSink sink() {
        return this.sink;
    }

    static class WaitableMetricsBuffer
    extends MetricsBuffer {
        private final Semaphore notificationSemaphore = new Semaphore(0);

        public WaitableMetricsBuffer(MetricsBuffer metricsBuffer) {
            super(metricsBuffer);
        }

        public boolean waitTillNotified(long millisecondsToWait) {
            try {
                return this.notificationSemaphore.tryAcquire(millisecondsToWait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        public void notifyAnyWaiters() {
            this.notificationSemaphore.release();
        }
    }
}

