/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
@Metrics(name="ShuffleClientMetrics", context="mapred")
public class ShuffleClientMetrics {
    private static final MetricsInfo RECORD_INFO = Interns.info("ShuffleClientMetrics", "Metrics for Shuffle client");
    @Metric
    private MutableCounterInt numFailedFetches;
    @Metric
    private MutableCounterInt numSuccessFetches;
    @Metric
    private MutableCounterLong numBytes;
    @Metric
    private MutableGaugeInt numThreadsBusy;
    private final MetricsRegistry metricsRegistry = new MetricsRegistry(RECORD_INFO);

    private ShuffleClientMetrics() {
    }

    public static ShuffleClientMetrics create(TaskAttemptID reduceId, JobConf jobConf) {
        MetricsSystem ms = DefaultMetricsSystem.initialize("JobTracker");
        ShuffleClientMetrics shuffleClientMetrics = new ShuffleClientMetrics();
        shuffleClientMetrics.addTags(reduceId, jobConf);
        return ms.register("ShuffleClientMetrics-" + ThreadLocalRandom.current().nextInt(), null, shuffleClientMetrics);
    }

    public void inputBytes(long bytes) {
        this.numBytes.incr(bytes);
    }

    public void failedFetch() {
        this.numFailedFetches.incr();
    }

    public void successFetch() {
        this.numSuccessFetches.incr();
    }

    public void threadBusy() {
        this.numThreadsBusy.incr();
    }

    public void threadFree() {
        this.numThreadsBusy.decr();
    }

    private void addTags(TaskAttemptID reduceId, JobConf jobConf) {
        this.metricsRegistry.tag("user", "", jobConf.getUser()).tag("jobName", "", jobConf.getJobName()).tag("jobId", "", reduceId.getJobID().toString()).tag("taskId", "", reduceId.toString());
    }

    @VisibleForTesting
    MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }
}

