/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Diff<K, E extends Element<K>> {
    private static final int DEFAULT_ARRAY_INITIAL_CAPACITY = 4;
    private List<E> created;
    private List<E> deleted;

    protected static <K, E extends Comparable<K>> int search(List<E> elements, K name) {
        return elements == null ? -1 : Collections.binarySearch(elements, name);
    }

    private static <E> void remove(List<E> elements, int i, E expected) {
        E removed = elements.remove(-i - 1);
        Preconditions.checkState(removed == expected, "removed != expected=%s, removed=%s.", expected, removed);
    }

    protected Diff() {
    }

    protected Diff(List<E> created, List<E> deleted) {
        this.created = created;
        this.deleted = deleted;
    }

    public List<E> getCreatedUnmodifiable() {
        return this.created != null ? Collections.unmodifiableList(this.created) : Collections.emptyList();
    }

    public E setCreated(int index, E element) {
        Element old = (Element)this.created.set(index, element);
        if (old.compareTo(element.getKey()) != 0) {
            throw new AssertionError((Object)("Element mismatched: element=" + element + " but old=" + old));
        }
        return (E)old;
    }

    public void clearCreated() {
        if (this.created != null) {
            this.created.clear();
        }
    }

    public List<E> getDeletedUnmodifiable() {
        return this.deleted != null ? Collections.unmodifiableList(this.deleted) : Collections.emptyList();
    }

    public boolean containsDeleted(K key) {
        if (this.deleted != null) {
            return Diff.search(this.deleted, key) >= 0;
        }
        return false;
    }

    public boolean containsDeleted(E element) {
        return this.getDeleted(element.getKey()) == element;
    }

    public E getDeleted(K key) {
        int c;
        if (this.deleted != null && (c = Diff.search(this.deleted, key)) >= 0) {
            return (E)((Element)this.deleted.get(c));
        }
        return null;
    }

    public boolean removeDeleted(E element) {
        int i;
        if (this.deleted != null && (i = Diff.search(this.deleted, element.getKey())) >= 0 && this.deleted.get(i) == element) {
            this.deleted.remove(i);
            return true;
        }
        return false;
    }

    public void clearDeleted() {
        if (this.deleted != null) {
            this.deleted.clear();
        }
    }

    public boolean isEmpty() {
        return !(this.created != null && !this.created.isEmpty() || this.deleted != null && !this.deleted.isEmpty());
    }

    private void addCreated(E element, int i) {
        if (i >= 0) {
            throw new AssertionError((Object)("Element already exists: element=" + element + ", created=" + this.created));
        }
        if (this.created == null) {
            this.created = new ArrayList(4);
        }
        this.created.add(-i - 1, element);
    }

    private void addDeleted(E element, int i) {
        if (i >= 0) {
            throw new AssertionError((Object)("Element already exists: element=" + element + ", deleted=" + this.deleted));
        }
        if (this.deleted == null) {
            this.deleted = new ArrayList(4);
        }
        this.deleted.add(-i - 1, element);
    }

    public int create(E element) {
        int c = Diff.search(this.created, element.getKey());
        this.addCreated(element, c);
        return c;
    }

    public void undoCreate(E element, int insertionPoint) {
        Diff.remove(this.created, insertionPoint, element);
    }

    public UndoInfo<E> delete(E element) {
        int c = Diff.search(this.created, element.getKey());
        Element previous = null;
        Integer d = null;
        if (c >= 0) {
            previous = (Element)this.created.remove(c);
        } else {
            d = Diff.search(this.deleted, element.getKey());
            this.addDeleted(element, d);
        }
        return new UndoInfo(c, previous, d);
    }

    public void undoDelete(E element, UndoInfo<E> undoInfo) {
        int c = ((UndoInfo)undoInfo).createdInsertionPoint;
        if (c >= 0) {
            this.created.add(c, ((UndoInfo)undoInfo).trashed);
        } else {
            Diff.remove(this.deleted, ((UndoInfo)undoInfo).deletedInsertionPoint, element);
        }
    }

    public UndoInfo<E> modify(E oldElement, E newElement) {
        Preconditions.checkArgument(oldElement != newElement, "They are the same object: oldElement == newElement = %s", newElement);
        Preconditions.checkArgument(oldElement.compareTo(newElement.getKey()) == 0, "The names do not match: oldElement=%s, newElement=%s", oldElement, newElement);
        int c = Diff.search(this.created, newElement.getKey());
        Element<Object> previous = null;
        Integer d = null;
        if (c >= 0) {
            previous = (Element)this.created.set(c, newElement);
            previous = oldElement;
        } else {
            d = Diff.search(this.deleted, oldElement.getKey());
            if (d < 0) {
                this.addCreated(newElement, c);
                this.addDeleted(oldElement, d);
            }
        }
        return new UndoInfo(c, previous, d);
    }

    public void undoModify(E oldElement, E newElement, UndoInfo<E> undoInfo) {
        int c = ((UndoInfo)undoInfo).createdInsertionPoint;
        if (c >= 0) {
            this.created.set(c, ((UndoInfo)undoInfo).trashed);
        } else {
            int d = ((UndoInfo)undoInfo).deletedInsertionPoint;
            if (d < 0) {
                Diff.remove(this.created, c, newElement);
                Diff.remove(this.deleted, d, oldElement);
            }
        }
    }

    public Container<E> accessPrevious(K name) {
        return Diff.accessPrevious(name, this.created, this.deleted);
    }

    private static <K, E extends Element<K>> Container<E> accessPrevious(K name, List<E> clist, List<E> dlist) {
        int d = Diff.search(dlist, name);
        if (d >= 0) {
            return new Container(dlist.get(d));
        }
        int c = Diff.search(clist, name);
        return c < 0 ? null : new Container(null);
    }

    public Container<E> accessCurrent(K name) {
        return Diff.accessPrevious(name, this.deleted, this.created);
    }

    public List<E> apply2Previous(List<E> previous) {
        return Diff.apply2Previous(previous, this.getCreatedUnmodifiable(), this.getDeletedUnmodifiable());
    }

    private static <K, E extends Element<K>> List<E> apply2Previous(List<E> previous, List<E> clist, List<E> dlist) {
        Element c;
        ArrayList<Element<Object>> tmp = new ArrayList<Element<Object>>(previous.size() - dlist.size());
        Iterator<E> i = previous.iterator();
        for (Element deleted : dlist) {
            Element e = (Element)i.next();
            int cmp = 0;
            while ((cmp = e.compareTo(deleted.getKey())) < 0) {
                tmp.add(e);
                e = (Element)i.next();
            }
            Preconditions.checkState(cmp == 0);
        }
        while (i.hasNext()) {
            tmp.add((Element<Object>)i.next());
        }
        ArrayList<Element> current = new ArrayList<Element>(tmp.size() + clist.size());
        Iterator tmpIterator = tmp.iterator();
        Iterator<E> cIterator = clist.iterator();
        Element t = tmpIterator.hasNext() ? (Element)tmpIterator.next() : null;
        Element element = c = cIterator.hasNext() ? (Element)cIterator.next() : null;
        while (t != null || c != null) {
            int cmp;
            int n = c == null ? 1 : (cmp = t == null ? -1 : c.compareTo(t.getKey()));
            if (cmp < 0) {
                current.add(c);
                c = cIterator.hasNext() ? (Element)cIterator.next() : null;
                continue;
            }
            if (cmp > 0) {
                current.add(t);
                t = tmpIterator.hasNext() ? (Element)tmpIterator.next() : null;
                continue;
            }
            throw new AssertionError((Object)"Violated assumption (A3).");
        }
        return current;
    }

    public List<E> apply2Current(List<E> current) {
        return Diff.apply2Previous(current, this.getDeletedUnmodifiable(), this.getCreatedUnmodifiable());
    }

    public void combinePosterior(Diff<K, E> posterior, Processor<E> deletedProcesser) {
        Element d;
        Iterator<E> createdIterator = posterior.getCreatedUnmodifiable().iterator();
        Iterator<E> deletedIterator = posterior.getDeletedUnmodifiable().iterator();
        Element c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
        Element element = d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
        while (c != null || d != null) {
            UndoInfo<Element> ui;
            int cmp;
            int n = c == null ? 1 : (cmp = d == null ? -1 : c.compareTo(d.getKey()));
            if (cmp < 0) {
                this.create(c);
                c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
                continue;
            }
            if (cmp > 0) {
                ui = this.delete(d);
                if (deletedProcesser != null) {
                    deletedProcesser.process(((UndoInfo)ui).trashed);
                }
                d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
                continue;
            }
            ui = this.modify(d, c);
            if (deletedProcesser != null) {
                deletedProcesser.process(((UndoInfo)ui).trashed);
            }
            c = createdIterator.hasNext() ? (Element)createdIterator.next() : null;
            d = deletedIterator.hasNext() ? (Element)deletedIterator.next() : null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{created=" + this.getCreatedUnmodifiable() + ", deleted=" + this.getDeletedUnmodifiable() + "}";
    }

    public static class UndoInfo<E> {
        private final int createdInsertionPoint;
        private final E trashed;
        private final Integer deletedInsertionPoint;

        private UndoInfo(int createdInsertionPoint, E trashed, Integer deletedInsertionPoint) {
            this.createdInsertionPoint = createdInsertionPoint;
            this.trashed = trashed;
            this.deletedInsertionPoint = deletedInsertionPoint;
        }

        public E getTrashedElement() {
            return this.trashed;
        }
    }

    public static class Container<E> {
        private final E element;

        private Container(E element) {
            this.element = element;
        }

        public E getElement() {
            return this.element;
        }
    }

    public static interface Processor<E> {
        public void process(E var1);
    }

    public static interface Element<K>
    extends Comparable<K> {
        public K getKey();
    }
}

