/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import io.trino.hadoop.$internal.com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StatisticsEditsVisitor
implements OfflineEditsVisitor {
    private final PrintWriter out;
    private int version = -1;
    private final Map<FSEditLogOpCodes, Long> opCodeCount = new HashMap<FSEditLogOpCodes, Long>();

    public StatisticsEditsVisitor(OutputStream out) throws IOException {
        this.out = new PrintWriter(new OutputStreamWriter(out, Charsets.UTF_8));
    }

    @Override
    public void start(int version) throws IOException {
        this.version = version;
    }

    @Override
    public void close(Throwable error) throws IOException {
        this.out.print(this.getStatisticsString());
        if (error != null) {
            this.out.print("EXITING ON ERROR: " + error.toString() + "\n");
        }
        this.out.close();
    }

    @Override
    public void visitOp(FSEditLogOp op) throws IOException {
        this.incrementOpCodeCount(op.opCode);
    }

    private void incrementOpCodeCount(FSEditLogOpCodes opCode) {
        if (!this.opCodeCount.containsKey((Object)opCode)) {
            this.opCodeCount.put(opCode, 0L);
        }
        Long newValue = this.opCodeCount.get((Object)opCode) + 1L;
        this.opCodeCount.put(opCode, newValue);
    }

    public Map<FSEditLogOpCodes, Long> getStatistics() {
        return this.opCodeCount;
    }

    public String getStatisticsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("    %-30.30s      : %d%n", "VERSION", this.version));
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            Long count = this.opCodeCount.get((Object)opCode);
            sb.append(String.format("    %-30.30s (%3d): %d%n", opCode.toString(), opCode.getOpCode(), count == null ? Long.valueOf(0L) : count));
        }
        return sb.toString();
    }
}

