/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ExternalStoragePolicySatisfier {
    public static final Logger LOG = LoggerFactory.getLogger(ExternalStoragePolicySatisfier.class);

    private ExternalStoragePolicySatisfier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (NameNodeConnector nnc = null;){
            StringUtils.startupShutdownMessage(StoragePolicySatisfier.class, args, LOG);
            HdfsConfiguration spsConf = new HdfsConfiguration();
            ExternalStoragePolicySatisfier.secureLogin(spsConf);
            StoragePolicySatisfier sps = new StoragePolicySatisfier(spsConf);
            nnc = ExternalStoragePolicySatisfier.getNameNodeConnector(spsConf);
            ExternalSPSContext context = new ExternalSPSContext(sps, nnc);
            sps.init(context);
            sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
            if (sps != null) {
                sps.join();
            }
        }
    }

    private static void secureLogin(Configuration conf) throws IOException {
        UserGroupInformation.setConfiguration(conf);
        String addr = conf.get("dfs.storage.policy.satisfier.address", "0.0.0.0:0");
        InetSocketAddress socAddr = NetUtils.createSocketAddr(addr, 0, "dfs.storage.policy.satisfier.address");
        SecurityUtil.login(conf, "dfs.storage.policy.satisfier.keytab.file", "dfs.storage.policy.satisfier.kerberos.principal", socAddr.getHostName());
    }

    private static NameNodeConnector getNameNodeConnector(Configuration conf) throws IOException, InterruptedException {
        Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
        Path externalSPSPathId = HdfsServerConstants.MOVER_ID_PATH;
        while (true) {
            try {
                List<NameNodeConnector> nncs = NameNodeConnector.newNameNodeConnectors(namenodes, ExternalStoragePolicySatisfier.class.getSimpleName(), externalSPSPathId, conf, 5);
                return nncs.get(0);
            }
            catch (IOException e) {
                LOG.warn("Failed to connect with namenode", e);
                Thread.sleep(3000L);
                continue;
            }
            break;
        }
    }
}

