/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import io.trino.hadoop.$internal.com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockECReconstructionCommand
extends DatanodeCommand {
    private final Collection<BlockECReconstructionInfo> ecTasks;

    public BlockECReconstructionCommand(int action, Collection<BlockECReconstructionInfo> blockECReconstructionInfoList) {
        super(action);
        this.ecTasks = blockECReconstructionInfoList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockECReconstructionCommand(\n  ");
        Joiner.on("\n  ").appendTo(sb, (Iterable<?>)this.ecTasks);
        sb.append("\n)");
        return sb.toString();
    }

    public Collection<BlockECReconstructionInfo> getECTasks() {
        return this.ecTasks;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockECReconstructionInfo {
        private final ExtendedBlock block;
        private final DatanodeInfo[] sources;
        private DatanodeInfo[] targets;
        private String[] targetStorageIDs;
        private StorageType[] targetStorageTypes;
        private final byte[] liveBlockIndices;
        private final ErasureCodingPolicy ecPolicy;

        public BlockECReconstructionInfo(ExtendedBlock block, DatanodeInfo[] sources, DatanodeStorageInfo[] targetDnStorageInfo, byte[] liveBlockIndices, ErasureCodingPolicy ecPolicy) {
            this(block, sources, DatanodeStorageInfo.toDatanodeInfos(targetDnStorageInfo), DatanodeStorageInfo.toStorageIDs(targetDnStorageInfo), DatanodeStorageInfo.toStorageTypes(targetDnStorageInfo), liveBlockIndices, ecPolicy);
        }

        public BlockECReconstructionInfo(ExtendedBlock block, DatanodeInfo[] sources, DatanodeInfo[] targets, String[] targetStorageIDs, StorageType[] targetStorageTypes, byte[] liveBlockIndices, ErasureCodingPolicy ecPolicy) {
            this.block = block;
            this.sources = sources;
            this.targets = targets;
            this.targetStorageIDs = targetStorageIDs;
            this.targetStorageTypes = targetStorageTypes;
            this.liveBlockIndices = liveBlockIndices == null ? new byte[]{} : liveBlockIndices;
            this.ecPolicy = ecPolicy;
        }

        public ExtendedBlock getExtendedBlock() {
            return this.block;
        }

        public DatanodeInfo[] getSourceDnInfos() {
            return this.sources;
        }

        public DatanodeInfo[] getTargetDnInfos() {
            return this.targets;
        }

        public String[] getTargetStorageIDs() {
            return this.targetStorageIDs;
        }

        public StorageType[] getTargetStorageTypes() {
            return this.targetStorageTypes;
        }

        public byte[] getLiveBlockIndices() {
            return this.liveBlockIndices;
        }

        public ErasureCodingPolicy getErasureCodingPolicy() {
            return this.ecPolicy;
        }

        public String toString() {
            return "BlockECReconstructionInfo(\n  " + "Recovering " + this.block + " From: " + Arrays.asList(this.sources) + " To: [" + Arrays.asList(this.targets) + ")\n" + " Block Indices: " + Arrays.toString(this.liveBlockIndices);
        }
    }
}

