/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;

public class StoragePolicySatisfyManager {
    private static final Logger LOG = LoggerFactory.getLogger(StoragePolicySatisfyManager.class);
    private final StoragePolicySatisfier spsService;
    private final boolean storagePolicyEnabled;
    private volatile HdfsConstants.StoragePolicySatisfierMode mode;
    private final Queue<Long> pathsToBeTraveresed;
    private final int outstandingPathsLimit;
    private final Namesystem namesystem;

    public StoragePolicySatisfyManager(Configuration conf, Namesystem namesystem) {
        this.storagePolicyEnabled = conf.getBoolean("dfs.storage.policy.enabled", true);
        String modeVal = conf.get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT);
        this.outstandingPathsLimit = conf.getInt("dfs.storage.policy.satisfier.max.outstanding.paths", 10000);
        this.mode = HdfsConstants.StoragePolicySatisfierMode.fromString(modeVal);
        this.pathsToBeTraveresed = new LinkedList<Long>();
        this.namesystem = namesystem;
        this.spsService = new StoragePolicySatisfier(conf);
    }

    public void start() {
        if (!this.storagePolicyEnabled) {
            LOG.info("Disabling StoragePolicySatisfier service as {} set to {}.", (Object)"dfs.storage.policy.enabled", (Object)this.storagePolicyEnabled);
            return;
        }
        switch (this.mode) {
            case EXTERNAL: {
                LOG.info("Storage policy satisfier is configured as external, please start external sps service explicitly to satisfy policy");
                break;
            }
            case NONE: {
                LOG.info("Storage policy satisfier is disabled");
                break;
            }
            default: {
                LOG.info("Given mode: {} is invalid", (Object)this.mode);
            }
        }
    }

    public void stop() {
        if (!this.storagePolicyEnabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storage policy is not enabled, ignoring");
            }
            return;
        }
        switch (this.mode) {
            case EXTERNAL: {
                this.removeAllPathIds();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Storage policy satisfier service is running outside namenode, ignoring");
                break;
            }
            case NONE: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Storage policy satisfier is not enabled, ignoring");
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Invalid mode:{}, ignoring", (Object)this.mode);
            }
        }
    }

    public void changeModeEvent(HdfsConstants.StoragePolicySatisfierMode newMode) {
        if (!this.storagePolicyEnabled) {
            LOG.info("Failed to change storage policy satisfier as {} set to {}.", (Object)"dfs.storage.policy.enabled", (Object)this.storagePolicyEnabled);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating SPS service status, current mode:{}, new mode:{}", (Object)this.mode, (Object)newMode);
        }
        switch (newMode) {
            case EXTERNAL: {
                if (this.mode == newMode) {
                    LOG.info("Storage policy satisfier is already in mode:{}, so ignoring change mode event.", (Object)newMode);
                    return;
                }
                this.spsService.stopGracefully();
                break;
            }
            case NONE: {
                if (this.mode == newMode) {
                    LOG.info("Storage policy satisfier is already disabled, mode:{} so ignoring change mode event.", (Object)newMode);
                    return;
                }
                LOG.info("Disabling StoragePolicySatisfier, mode:{}", (Object)newMode);
                this.spsService.stop(true);
                this.clearPathIds();
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Given mode: {} is invalid", (Object)newMode);
            }
        }
        this.mode = newMode;
    }

    @VisibleForTesting
    public boolean isSatisfierRunning() {
        return this.spsService.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextPathId() {
        Queue<Long> queue = this.pathsToBeTraveresed;
        synchronized (queue) {
            return this.pathsToBeTraveresed.poll();
        }
    }

    public void verifyOutstandingPathQLimit() throws IOException {
        long size = this.pathsToBeTraveresed.size();
        if ((long)this.outstandingPathsLimit - size <= 0L) {
            LOG.debug("Satisifer Q - outstanding limit:{}, current size:{}", (Object)this.outstandingPathsLimit, (Object)size);
            throw new IOException("Outstanding satisfier queue limit: " + this.outstandingPathsLimit + " exceeded, try later!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPathIds() {
        Queue<Long> queue = this.pathsToBeTraveresed;
        synchronized (queue) {
            Iterator iterator = this.pathsToBeTraveresed.iterator();
            while (iterator.hasNext()) {
                Long trackId = (Long)iterator.next();
                try {
                    this.namesystem.removeXattr(trackId, "user.hdfs.sps");
                }
                catch (IOException e) {
                    LOG.debug("Failed to remove sps xatttr!", e);
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPathIds() {
        Queue<Long> queue = this.pathsToBeTraveresed;
        synchronized (queue) {
            this.pathsToBeTraveresed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPathId(long id) {
        Queue<Long> queue = this.pathsToBeTraveresed;
        synchronized (queue) {
            this.pathsToBeTraveresed.add(id);
        }
    }

    public boolean isEnabled() {
        return this.mode == HdfsConstants.StoragePolicySatisfierMode.EXTERNAL;
    }

    public HdfsConstants.StoragePolicySatisfierMode getMode() {
        return this.mode;
    }
}

