/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.connectors;

import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectReader;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;

public class JsonNodeConnector
implements ClusterConnector {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeConnector.class);
    private static final ObjectReader READER = new ObjectMapper().readerFor(DiskBalancerCluster.class);
    private final URL clusterURI;

    public JsonNodeConnector(URL clusterURI) {
        this.clusterURI = clusterURI;
    }

    @Override
    public List<DiskBalancerDataNode> getNodes() throws Exception {
        Preconditions.checkNotNull(this.clusterURI);
        String dataFilePath = this.clusterURI.getPath();
        LOG.info("Reading cluster info from file : " + dataFilePath);
        DiskBalancerCluster cluster = (DiskBalancerCluster)READER.readValue(new File(dataFilePath));
        String message = String.format("Found %d node(s)", cluster.getNodes().size());
        LOG.info(message);
        return cluster.getNodes();
    }

    @Override
    public String getConnectorInfo() {
        return "Json Cluster Connector : Connects to a JSON file that describes a cluster : " + this.clusterURI.toString();
    }
}

