/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.sps;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.common.sps.BlockMovementAttemptFinished;
import org.apache.hadoop.hdfs.server.common.sps.BlocksMovementsStatusHandler;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockStorageMovementTracker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockStorageMovementTracker.class);
    private final CompletionService<BlockMovementAttemptFinished> moverCompletionService;
    private final BlocksMovementsStatusHandler blksMovementsStatusHandler;
    private volatile boolean running = true;

    public BlockStorageMovementTracker(CompletionService<BlockMovementAttemptFinished> moverCompletionService, BlocksMovementsStatusHandler handler) {
        this.moverCompletionService = moverCompletionService;
        this.blksMovementsStatusHandler = handler;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Future<BlockMovementAttemptFinished> future = this.moverCompletionService.take();
                if (future == null) continue;
                BlockMovementAttemptFinished result = future.get();
                LOG.debug("Completed block movement. {}", (Object)result);
                if (!this.running || this.blksMovementsStatusHandler == null) continue;
                this.blksMovementsStatusHandler.handle(result);
            }
            catch (InterruptedException e) {
                if (!this.running) continue;
                LOG.error("Exception while moving block replica to target storage type", e);
            }
            catch (ExecutionException e) {
                LOG.error("Exception while moving block replica to target storage type", e);
            }
        }
    }

    public void stopTracking() {
        this.running = false;
    }
}

