/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.apache.commons.logging.Log;
import io.trino.hadoop.$internal.org.apache.log4j.Appender;
import io.trino.hadoop.$internal.org.apache.log4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.metrics2.util.MBeans;

public class MetricsLoggerTask
implements Runnable {
    public static final io.trino.hadoop.$internal.org.slf4j.Logger LOG = LoggerFactory.getLogger(MetricsLoggerTask.class);
    private static ObjectName objectName = null;
    private Log metricsLog;
    private String nodeName;
    private short maxLogLineLength;

    public MetricsLoggerTask(Log metricsLog, String nodeName, short maxLogLineLength) {
        this.metricsLog = metricsLog;
        this.nodeName = nodeName;
        this.maxLogLineLength = maxLogLineLength;
    }

    @Override
    public void run() {
        if (!this.metricsLog.isInfoEnabled() || !MetricsLoggerTask.hasAppenders(this.metricsLog) || objectName == null) {
            return;
        }
        this.metricsLog.info(" >> Begin " + this.nodeName + " metrics dump");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName mbeanName : server.queryNames(objectName, null)) {
            try {
                MBeanInfo mBeanInfo = server.getMBeanInfo(mbeanName);
                String mBeanNameName = MBeans.getMbeanNameName(mbeanName);
                Set<String> attributeNames = MetricsLoggerTask.getFilteredAttributes(mBeanInfo);
                AttributeList attributes = server.getAttributes(mbeanName, attributeNames.toArray(new String[attributeNames.size()]));
                for (Object o : attributes) {
                    Attribute attribute = (Attribute)o;
                    Object value = attribute.getValue();
                    String valueStr = value != null ? value.toString() : "null";
                    this.metricsLog.info(mBeanNameName + ":" + attribute.getName() + "=" + this.trimLine(valueStr));
                }
            }
            catch (Exception e) {
                this.metricsLog.error("Failed to get " + this.nodeName + " metrics for mbean " + mbeanName.toString(), e);
            }
        }
        this.metricsLog.info(" << End " + this.nodeName + " metrics dump");
    }

    private String trimLine(String valueStr) {
        if (this.maxLogLineLength <= 0) {
            return valueStr;
        }
        return valueStr.length() < this.maxLogLineLength ? valueStr : valueStr.substring(0, this.maxLogLineLength) + "...";
    }

    private static boolean hasAppenders(Log logger) {
        if (!(logger instanceof .Log4JLogger)) {
            return true;
        }
        .Log4JLogger log4JLogger = (.Log4JLogger)logger;
        return log4JLogger.getLogger().getAllAppenders().hasMoreElements();
    }

    private static Set<String> getFilteredAttributes(MBeanInfo mBeanInfo) {
        HashSet<String> attributeNames = new HashSet<String>();
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            if (attributeInfo.getType().equals("javax.management.openmbean.TabularData") || attributeInfo.getType().equals("javax.management.openmbean.CompositeData") || attributeInfo.getType().equals("[Ljavax.management.openmbean.CompositeData;")) continue;
            attributeNames.add(attributeInfo.getName());
        }
        return attributeNames;
    }

    public static void makeMetricsLoggerAsync(Log metricsLog) {
        if (!(metricsLog instanceof .Log4JLogger)) {
            LOG.warn("Metrics logging will not be async since the logger is not log4j");
            return;
        }
        Logger logger = ((.Log4JLogger)metricsLog).getLogger();
        logger.setAdditivity(false);
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof .AsyncAppender)) {
            .AsyncAppender asyncAppender = new .AsyncAppender();
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    static {
        try {
            objectName = new ObjectName("Hadoop:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

