/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReconstructionWork;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.net.Node;

class ReplicationWork
extends BlockReconstructionWork {
    public ReplicationWork(BlockInfo block, BlockCollection bc, DatanodeDescriptor[] srcNodes, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority) {
        super(block, bc, srcNodes, containingNodes, liveReplicaStorages, additionalReplRequired, priority);
        assert (this.getSrcNodes().length == 1) : "There should be exactly 1 source node that have been selected";
        this.getSrcNodes()[0].incrementPendingReplicationWithoutTargets();
        BlockManager.LOG.debug("Creating a ReplicationWork to reconstruct " + block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void chooseTargets(BlockPlacementPolicy blockplacement, BlockStoragePolicySuite storagePolicySuite, Set<Node> excludedNodes) {
        assert (this.getSrcNodes().length > 0) : "At least 1 source node should have been selected";
        try {
            DatanodeStorageInfo[] chosenTargets = blockplacement.chooseTarget(this.getSrcPath(), this.getAdditionalReplRequired(), this.getSrcNodes()[0], this.getLiveReplicaStorages(), false, excludedNodes, this.getBlockSize(), storagePolicySuite.getPolicy(this.getStoragePolicyID()), null);
            this.setTargets(chosenTargets);
        }
        finally {
            this.getSrcNodes()[0].decrementPendingReplicationWithoutTargets();
        }
    }

    @Override
    void addTaskToDatanode(NumberReplicas numberReplicas) {
        this.getSrcNodes()[0].addBlockToBeReplicated(this.getBlock(), this.getTargets());
    }
}

