/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;

public class UserPasswordTokenProvider
extends AccessTokenProvider {
    private final String authEndpoint;
    private final String username;
    private final String password;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public UserPasswordTokenProvider(String authEndpoint, String username, String password) {
        Preconditions.checkNotNull(authEndpoint, "authEndpoint");
        Preconditions.checkNotNull(username, "username");
        Preconditions.checkNotNull(password, "password");
        this.authEndpoint = authEndpoint;
        this.username = username;
        this.password = password;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing user-password based token");
        return AzureADAuthenticator.getTokenUsingClientCreds(this.authEndpoint, this.username, this.password);
    }
}

