/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.util;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class PublicKeyDeriver {
    public static PublicKey derivePublicKey(PrivateKey key) throws GeneralSecurityException {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            DSAParams keyParams = dsaKey.getParams();
            BigInteger g = keyParams.getG();
            BigInteger p = keyParams.getP();
            BigInteger q = keyParams.getQ();
            BigInteger x = dsaKey.getX();
            BigInteger y = q.modPow(x, p);
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(y, p, q, g);
            return KeyFactory.getInstance("DSA").generatePublic(keySpec);
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            BigInteger modulus = rsaKey.getModulus();
            BigInteger exponent = rsaKey.getPublicExponent();
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            return KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        throw new KeyException("Private key was not a DSA or RSA key");
    }
}

