/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.impl;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.ClientUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbSetting;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.impl.AbstractInternalKrbClient;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.impl.DefaultKrbHandler;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.TgsRequest;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbNetwork;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DefaultInternalKrbClient
extends AbstractInternalKrbClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInternalKrbClient.class);
    private DefaultKrbHandler krbHandler;
    private KrbTransport transport;

    public DefaultInternalKrbClient(KrbSetting krbSetting) {
        super(krbSetting);
    }

    @Override
    public void init() throws KrbException {
        super.init();
        this.krbHandler = new DefaultKrbHandler();
        this.krbHandler.init(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(KdcRequest request) throws KrbException {
        List<String> kdcList = ClientUtil.getKDCList(this.getSetting());
        Iterator<String> tempKdc = kdcList.iterator();
        if (!tempKdc.hasNext()) {
            throw new KrbException("Cannot get kdc for realm " + this.getSetting().getKdcRealm());
        }
        try {
            this.sendIfPossible(request, tempKdc.next(), this.getSetting(), false);
            LOG.info("Send to kdc success.");
        }
        catch (Exception first) {
            boolean ok = false;
            while (tempKdc.hasNext()) {
                try {
                    this.sendIfPossible(request, tempKdc.next(), this.getSetting(), true);
                    ok = true;
                    LOG.info("Send to kdc success.");
                    break;
                }
                catch (Exception ignore) {
                    LOG.info("ignore this kdc");
                }
            }
            if (!ok) {
                if (first instanceof KrbException) {
                    throw (KrbException)first;
                }
                throw new KrbException("The request failed " + first.getMessage(), (Throwable)first);
            }
        }
        finally {
            if (this.transport != null) {
                this.transport.release();
            }
        }
    }

    private void sendIfPossible(KdcRequest request, String kdcString, KrbSetting setting, boolean tryNextKdc) throws KrbException, IOException {
        .TransportPair tpair = ClientUtil.getTransportPair(setting, kdcString);
        KrbNetwork network = new KrbNetwork();
        network.setSocketTimeout(setting.getTimeout());
        this.transport = network.connect(tpair);
        request.setSessionData(this.transport);
        this.krbHandler.handleRequest(request, tryNextKdc);
    }

    @Override
    protected .TgtTicket doRequestTgt(AsRequest tgtTktReq) throws KrbException {
        this.doRequest(tgtTktReq);
        return tgtTktReq.getTicket();
    }

    @Override
    protected SgtTicket doRequestSgt(TgsRequest ticketReq) throws KrbException {
        this.doRequest(ticketReq);
        return ticketReq.getSgt();
    }
}

