/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.AuthUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.Krb5Conf;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminClient;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfig;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteAddPrincipalCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteDeletePrincipalCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteGetprincsCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemotePrintUsageCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteRenamePrincipalCommand;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.KrbUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcConfig;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbNetwork;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.TransportPair;
import io.trino.hadoop.$internal.org.apache.kerby.util.OSUtil;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Scanner;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class RemoteAdminClientTool {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAdminClientTool.class);
    private static final byte[] EMPTY = new byte[0];
    private static KrbTransport transport;
    private static final String PROMPT;
    private static final String USAGE;
    private static final String LEGAL_COMMANDS = "Available commands are: \nadd_principal, addprinc\n                         Add principal\ndelete_principal, delprinc\n                         Delete principal\nrename_principal, renprinc\n                         Rename principal\nlistprincs\n          List principals\n";

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String confDirPath = args[0];
        File confFile = new File(confDirPath, "adminClient.conf");
        final AdminConfig adminConfig = new AdminConfig();
        adminConfig.addKrb5Config(confFile);
        KdcConfig tmpKdcConfig = KdcUtil.getKdcConfig(new File(confDirPath));
        if (tmpKdcConfig == null) {
            tmpKdcConfig = new KdcConfig();
        }
        try {
            Krb5Conf krb5Conf = new Krb5Conf(new File(confDirPath), tmpKdcConfig);
            krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
        AdminClient adminClient = new AdminClient(adminConfig);
        File keytabFile = new File(adminConfig.getKeyTabFile());
        if (keytabFile == null || !keytabFile.exists()) {
            System.err.println("Need the valid keytab file value in conf file.");
            return;
        }
        String adminRealm = adminConfig.getAdminRealm();
        adminClient.setAdminRealm(adminRealm);
        adminClient.setAllowTcp(true);
        adminClient.setAllowUdp(false);
        adminClient.setAdminTcpPort(adminConfig.getAdminPort());
        adminClient.init();
        System.out.println("admin init successful");
        TransportPair tpair = null;
        try {
            tpair = AdminUtil.getTransportPair(adminClient.getSetting());
        }
        catch (KrbException e) {
            LOG.error("Fail to get transport pair. " + e);
        }
        KrbNetwork network = new KrbNetwork();
        network.setSocketTimeout(adminClient.getSetting().getTimeout());
        try {
            transport = network.connect(tpair);
        }
        catch (IOException e) {
            throw new KrbException("Failed to create transport", (Throwable)e);
        }
        String adminPrincipal = KrbUtil.makeKadminPrincipal(adminClient.getSetting().getKdcRealm()).getName();
        Subject subject = null;
        try {
            subject = AuthUtil.loginUsingKeytab(adminPrincipal, new File(adminConfig.getKeyTabFile()));
        }
        catch (LoginException e) {
            LOG.error("Fail to login using keytab. " + e);
        }
        Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("javax.security.sasl.qop", "auth-conf");
                    props.put("javax.security.sasl.server.authentication", "true");
                    SaslClient saslClient = null;
                    try {
                        String protocol = adminConfig.getProtocol();
                        String serverName = adminConfig.getServerName();
                        saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, null, protocol, serverName, props, null);
                    }
                    catch (SaslException e) {
                        LOG.error("Fail to create sasl client. " + e);
                    }
                    if (saslClient == null) {
                        throw new KrbException("Unable to find client implementation for: GSSAPI");
                    }
                    byte[] response = new byte[]{};
                    try {
                        response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(EMPTY) : EMPTY;
                    }
                    catch (SaslException e) {
                        LOG.error("Sasl client evaluate challenge failed." + e);
                    }
                    RemoteAdminClientTool.sendMessage(response, saslClient);
                    ByteBuffer message = transport.receiveMessage();
                    while (!saslClient.isComplete()) {
                        int ssComplete = message.getInt();
                        if (ssComplete == 0) {
                            System.out.println("Sasl Server completed");
                        }
                        byte[] arr = new byte[message.remaining()];
                        message.get(arr);
                        byte[] challenge = saslClient.evaluateChallenge(arr);
                        RemoteAdminClientTool.sendMessage(challenge, saslClient);
                        if (saslClient.isComplete()) continue;
                        message = transport.receiveMessage();
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to run. " + e.toString());
                }
                return null;
            }
        });
        System.out.println("enter \"command\" to see legal commands.");
        try (Scanner scanner = new Scanner(System.in, "UTF-8");){
            String input = scanner.nextLine();
            while (!(input.equals("quit") || input.equals("exit") || input.equals("q"))) {
                RemoteAdminClientTool.excute(adminClient, input);
                System.out.print(PROMPT);
                input = scanner.nextLine();
            }
        }
    }

    private static void sendMessage(byte[] challenge, SaslClient saslClient) throws SaslException {
        ByteBuffer buffer = ByteBuffer.allocate(challenge.length + 8);
        buffer.putInt(challenge.length + 4);
        int scComplete = saslClient.isComplete() ? 0 : 1;
        buffer.putInt(scComplete);
        buffer.put(challenge);
        buffer.flip();
        try {
            transport.sendMessage(buffer);
        }
        catch (IOException e) {
            LOG.error("Failed to send Kerberos message. " + e.toString());
        }
    }

    private static void excute(AdminClient adminClient, String input) throws KrbException {
        if ((input = input.trim()).startsWith("command")) {
            System.out.println(LEGAL_COMMANDS);
            return;
        }
        RemoteCommand executor = null;
        if (input.startsWith("add_principal") || input.startsWith("addprinc")) {
            executor = new RemoteAddPrincipalCommand(adminClient);
        } else if (input.startsWith("delete_principal") || input.startsWith("delprinc")) {
            executor = new RemoteDeletePrincipalCommand(adminClient);
        } else if (input.startsWith("rename_principal") || input.startsWith("renprinc")) {
            executor = new RemoteRenamePrincipalCommand(adminClient);
        } else if (input.startsWith("list_principals")) {
            executor = new RemoteGetprincsCommand(adminClient);
        } else if (input.startsWith("listprincs")) {
            executor = new RemotePrintUsageCommand();
        } else {
            System.out.println(LEGAL_COMMANDS);
            return;
        }
        ((RemoteCommand)executor).execute(input);
    }

    static {
        PROMPT = RemoteAdminClientTool.class.getSimpleName() + ".local:";
        USAGE = (OSUtil.isWindows() ? "Usage: bin\\remote-admin-client.cmd" : "Usage: sh bin/remote-admin-client.sh") + " <conf-file>\n" + "\tExample:\n" + "\t\t" + (OSUtil.isWindows() ? "bin\\remote-admin-client.cmd" : "sh bin/remote-admin-client.sh") + " conf\n";
    }
}

