/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ser.std;

import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;

@JacksonStdImpl
public class CalendarSerializer
extends DateTimeSerializerBase<Calendar> {
    public static final CalendarSerializer instance = new CalendarSerializer();

    public CalendarSerializer() {
        this(null, null);
    }

    public CalendarSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Calendar.class, useTimestamp, customFormat);
    }

    public CalendarSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new CalendarSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Calendar value) {
        return value == null ? 0L : value.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Calendar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._asTimestamp(provider)) {
            jgen.writeNumber(this._timestamp(value));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jgen.writeString(this._customFormat.format(value.getTime()));
            }
        } else {
            provider.defaultSerializeDateValue(value.getTime(), jgen);
        }
    }
}

