/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.core;

import io.trino.hadoop.$internal.htrace.core.HTraceConfiguration;
import io.trino.hadoop.$internal.htrace.core.Span;
import io.trino.hadoop.$internal.htrace.core.SpanReceiver;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.Log;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.LogFactory;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

public class LocalFileSpanReceiver
extends SpanReceiver {
    private static final Log LOG = LogFactory.getLog(LocalFileSpanReceiver.class);
    public static final String PATH_KEY = "local.file.span.receiver.path";
    public static final String CAPACITY_KEY = "local.file.span.receiver.capacity";
    public static final int CAPACITY_DEFAULT = 5000;
    private static ObjectWriter JSON_WRITER = new ObjectMapper().writer();
    private final String path;
    private byte[][] bufferedSpans;
    private int bufferedSpansIndex;
    private final ReentrantLock bufferLock = new ReentrantLock();
    private final FileOutputStream stream;
    private final FileChannel channel;
    private final ReentrantLock channelLock = new ReentrantLock();
    private final int WRITEV_SIZE = 20;
    private static final ByteBuffer newlineBuf = ByteBuffer.wrap(new byte[]{10});

    public LocalFileSpanReceiver(HTraceConfiguration conf) {
        int capacity = conf.getInt(CAPACITY_KEY, 5000);
        if (capacity < 1) {
            throw new IllegalArgumentException("local.file.span.receiver.capacity must not be less than 1.");
        }
        String pathStr = conf.get(PATH_KEY);
        this.path = pathStr == null || pathStr.isEmpty() ? LocalFileSpanReceiver.getUniqueLocalTraceFileName() : pathStr;
        boolean success = false;
        try {
            this.stream = new FileOutputStream(this.path, true);
        }
        catch (IOException ioe) {
            LOG.error("Error opening " + this.path + ": " + ioe.getMessage());
            throw new RuntimeException(ioe);
        }
        this.channel = this.stream.getChannel();
        if (this.channel == null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                LOG.error("Error closing " + this.path, e);
            }
            LOG.error("Failed to get channel for " + this.path);
            throw new RuntimeException("Failed to get channel for " + this.path);
        }
        this.bufferedSpans = new byte[capacity][];
        this.bufferedSpansIndex = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new LocalFileSpanReceiver with path = " + this.path + ", capacity = " + capacity);
        }
    }

    private void doFlush(byte[][] toFlush, int len) throws IOException {
        int bidx = 0;
        int widx = 0;
        ByteBuffer[] writevBufs = new ByteBuffer[40];
        while (true) {
            if (widx == writevBufs.length) {
                this.channel.write(writevBufs);
                widx = 0;
            }
            if (bidx == len) break;
            writevBufs[widx] = ByteBuffer.wrap(toFlush[bidx]);
            writevBufs[widx + 1] = newlineBuf;
            ++bidx;
            widx += 2;
        }
        if (widx > 0) {
            this.channel.write(writevBufs, 0, widx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSpan(Span span) {
        byte[] jsonBuf = null;
        try {
            jsonBuf = JSON_WRITER.writeValueAsBytes(span);
        }
        catch (JsonProcessingException e) {
            LOG.error("receiveSpan(path=" + this.path + ", span=" + span + "): " + "Json processing error: " + e.getMessage());
            return;
        }
        byte[][] toFlush = null;
        this.bufferLock.lock();
        try {
            if (this.bufferedSpans == null) {
                LOG.debug("receiveSpan(path=" + this.path + ", span=" + span + "): " + "LocalFileSpanReceiver for " + this.path + " is closed.");
                return;
            }
            this.bufferedSpans[this.bufferedSpansIndex] = jsonBuf;
            ++this.bufferedSpansIndex;
            if (this.bufferedSpansIndex == this.bufferedSpans.length) {
                toFlush = this.bufferedSpans;
                this.bufferedSpansIndex = 0;
                this.bufferedSpans = new byte[this.bufferedSpans.length][];
            }
        }
        finally {
            this.bufferLock.unlock();
        }
        if (toFlush != null) {
            this.channelLock.lock();
            try {
                this.doFlush(toFlush, toFlush.length);
            }
            catch (IOException ioe) {
                LOG.error("Error flushing buffers to " + this.path + ": " + ioe.getMessage());
            }
            finally {
                this.channelLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        byte[][] toFlush = null;
        int numToFlush = 0;
        this.bufferLock.lock();
        try {
            if (this.bufferedSpans == null) {
                LOG.info("LocalFileSpanReceiver for " + this.path + " was already closed.");
                return;
            }
            numToFlush = this.bufferedSpansIndex;
            this.bufferedSpansIndex = 0;
            toFlush = this.bufferedSpans;
            this.bufferedSpans = null;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.channelLock.lock();
        try {
            this.doFlush(toFlush, numToFlush);
        }
        catch (IOException ioe) {
            LOG.error("Error flushing buffers to " + this.path + ": " + ioe.getMessage());
        }
        finally {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                LOG.error("Error closing stream for " + this.path, e);
            }
            this.channelLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueLocalTraceFileName() {
        String tmp = System.getProperty("java.io.tmpdir", "/tmp");
        String nonce = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/self/stat"), "UTF-8"));
            String line = reader.readLine();
            if (line == null) {
                throw new EOFException();
            }
            nonce = line.split(" ")[0];
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warn("Exception in closing " + reader, e);
                }
            }
        }
        if (nonce == null) {
            nonce = UUID.randomUUID().toString();
        }
        return new File(tmp, nonce).getAbsolutePath();
    }
}

