/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.swagger.annotations.ApiModelProperty;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public final class WorkerInfo
implements Serializable {
    private static final long serialVersionUID = -454711814438216780L;
    private long mId;
    private WorkerNetAddress mAddress = new WorkerNetAddress();
    private int mLastContactSec;
    private String mState = "";
    private long mCapacityBytes;
    private long mUsedBytes;
    private long mStartTimeMs;
    private Map<String, Long> mCapacityBytesOnTiers;
    private Map<String, Long> mUsedBytesOnTiers;

    @ApiModelProperty(value="Worker id, used to identify the worker internally")
    public long getId() {
        return this.mId;
    }

    @ApiModelProperty(value="Address of the worker")
    public WorkerNetAddress getAddress() {
        return this.mAddress;
    }

    @ApiModelProperty(value="Seconds since the worker's last contact")
    public int getLastContactSec() {
        return this.mLastContactSec;
    }

    @ApiModelProperty(value="Operation state of the worker", example="In Service")
    public String getState() {
        return this.mState;
    }

    @ApiModelProperty(value="Size of the worker's local storage in bytes")
    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    @ApiModelProperty(value="Number of bytes used of the worker's local storage")
    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    @ApiModelProperty(value="Start time of the worker in epoch time in milliseconds")
    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    @ApiModelProperty(value="The max capacity of each of the worker's tiers in bytes")
    public Map<String, Long> getCapacityBytesOnTiers() {
        return this.mCapacityBytesOnTiers;
    }

    @ApiModelProperty(value="The number of bytes currently used on each of the worker's tiers")
    public Map<String, Long> getUsedBytesOnTiers() {
        return this.mUsedBytesOnTiers;
    }

    public WorkerInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public WorkerInfo setAddress(WorkerNetAddress address) {
        Preconditions.checkNotNull(address, "address");
        this.mAddress = address;
        return this;
    }

    public WorkerInfo setLastContactSec(int lastContactSec) {
        this.mLastContactSec = lastContactSec;
        return this;
    }

    public WorkerInfo setState(String state) {
        Preconditions.checkNotNull(state, "state");
        this.mState = state;
        return this;
    }

    public WorkerInfo setCapacityBytes(long capacityBytes) {
        this.mCapacityBytes = capacityBytes;
        return this;
    }

    public WorkerInfo setUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
        return this;
    }

    public WorkerInfo setStartTimeMs(long startTimeMs) {
        this.mStartTimeMs = startTimeMs;
        return this;
    }

    public WorkerInfo setCapacityBytesOnTiers(Map<String, Long> capacityBytesOnTiers) {
        this.mCapacityBytesOnTiers = new HashMap<String, Long>(capacityBytesOnTiers);
        return this;
    }

    public WorkerInfo setUsedBytesOnTiers(Map<String, Long> usedBytesOnTiers) {
        this.mUsedBytesOnTiers = new HashMap<String, Long>(usedBytesOnTiers);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerInfo)) {
            return false;
        }
        WorkerInfo that = (WorkerInfo)o;
        return this.mId == that.mId && Objects.equal(this.mAddress, that.mAddress) && this.mLastContactSec == that.mLastContactSec && Objects.equal(this.mState, that.mState) && this.mCapacityBytes == that.mCapacityBytes && this.mUsedBytes == that.mUsedBytes && this.mStartTimeMs == that.mStartTimeMs && Objects.equal(this.mCapacityBytesOnTiers, that.mCapacityBytesOnTiers) && Objects.equal(this.mUsedBytesOnTiers, that.mUsedBytesOnTiers);
    }

    public int hashCode() {
        return Objects.hashCode(this.mId, this.mAddress, this.mLastContactSec, this.mState, this.mCapacityBytes, this.mUsedBytes, this.mStartTimeMs, this.mCapacityBytesOnTiers, this.mUsedBytesOnTiers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.mId).add("address", this.mAddress).add("lastContactSec", this.mLastContactSec).add("state", this.mState).add("capacityBytes", this.mCapacityBytes).add("usedBytes", this.mUsedBytes).add("startTimeMs", this.mStartTimeMs).add("capacityBytesOnTiers", this.mCapacityBytesOnTiers).add("usedBytesOnTiers", this.mUsedBytesOnTiers).toString();
    }

    public static final class LastContactSecComparator
    implements Comparator<WorkerInfo>,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int compare(WorkerInfo o1, WorkerInfo o2) {
            return o1.getLastContactSec() - o2.getLastContactSec();
        }
    }
}

