/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.user;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.login.AppLoginModule;
import alluxio.security.login.LoginModuleConfiguration;
import alluxio.security.user.BaseUserState;
import alluxio.security.user.UserState;
import alluxio.security.user.UserStateFactory;
import alluxio.util.SecurityUtils;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUserState
extends BaseUserState {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleUserState.class);

    private SimpleUserState(Subject subject, AlluxioConfiguration conf) {
        super(subject, conf);
    }

    @Override
    public User login() throws UnauthenticatedException {
        String username = "";
        if (this.mConf.isSet(PropertyKey.SECURITY_LOGIN_USERNAME)) {
            username = this.mConf.get(PropertyKey.SECURITY_LOGIN_USERNAME);
        }
        try {
            LoginContext loginContext = SecurityUtils.createLoginContext(AuthType.SIMPLE, this.mSubject, User.class.getClassLoader(), new LoginModuleConfiguration(), new AppLoginModule.AppCallbackHandler(username));
            loginContext.login();
        }
        catch (LoginException e) {
            throw new UnauthenticatedException("Failed to login: " + e.getMessage(), e);
        }
        LOG.debug("login subject: {}", (Object)this.mSubject);
        Set<User> userSet = this.mSubject.getPrincipals(User.class);
        if (userSet.isEmpty()) {
            throw new UnauthenticatedException("Failed to login: No Alluxio User is found.");
        }
        if (userSet.size() > 1) {
            StringBuilder msg = new StringBuilder("Failed to login: More than one Alluxio Users are found:");
            for (User user : userSet) {
                msg.append(" ").append(user.toString());
            }
            throw new UnauthenticatedException(msg.toString());
        }
        return userSet.iterator().next();
    }

    public static class Factory
    implements UserStateFactory {
        @Override
        public UserState create(Subject subject, AlluxioConfiguration conf, boolean isServer) {
            AuthType authType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            if (authType == AuthType.SIMPLE || authType == AuthType.CUSTOM) {
                return new SimpleUserState(subject, conf);
            }
            LOG.debug("N/A: auth type is not SIMPLE or CUSTOM. authType: {}", (Object)authType.getAuthName());
            return null;
        }
    }
}

