/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AccessControlException;
import alluxio.exception.ExceptionMessage;
import alluxio.security.User;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.SecurityUtils;
import java.io.IOException;

@ThreadSafe
public final class AuthenticatedClientUser {
    private static ThreadLocal<User> sUserThreadLocal = new ThreadLocal();
    private static ThreadLocal<User> sConnectionUserThreadLocal = new ThreadLocal();
    private static ThreadLocal<String> sConnectionAuthMethod = new ThreadLocal();

    public static void set(String userName) {
        sUserThreadLocal.set(new User(userName));
    }

    public static void set(User user) {
        sUserThreadLocal.set(user);
    }

    public static void setConnectionUser(String userName) {
        sConnectionUserThreadLocal.set(new User(userName));
    }

    public static void setAuthMethod(String authMethod) {
        sConnectionAuthMethod.set(authMethod);
    }

    public static User get(AlluxioConfiguration conf) throws IOException {
        if (!SecurityUtils.isAuthenticationEnabled(conf)) {
            throw new IOException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
        return sUserThreadLocal.get();
    }

    public static User getOrNull() {
        return sUserThreadLocal.get();
    }

    public static String getClientUser(AlluxioConfiguration conf) throws AccessControlException {
        try {
            User user = AuthenticatedClientUser.get(conf);
            if (user == null) {
                throw new AccessControlException(ExceptionMessage.AUTHORIZED_CLIENT_USER_IS_NULL.getMessage(new Object[0]));
            }
            return user.getName();
        }
        catch (IOException e) {
            throw new AccessControlException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
    }

    public static String getConnectionUser(AlluxioConfiguration conf) throws AccessControlException {
        if (!SecurityUtils.isAuthenticationEnabled(conf)) {
            throw new AccessControlException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
        User user = sConnectionUserThreadLocal.get();
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    public static String getAuthMethod(AlluxioConfiguration conf) throws AccessControlException {
        if (!SecurityUtils.isAuthenticationEnabled(conf)) {
            throw new AccessControlException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
        return sConnectionAuthMethod.get();
    }

    public static void remove() {
        sUserThreadLocal.remove();
    }

    private AuthenticatedClientUser() {
    }
}

