/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.exception.ExceptionMessage;
import alluxio.grpc.MetricType;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Strings;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetricKey
implements Comparable<MetricKey> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricKey.class);
    private static final Map<String, MetricKey> METRIC_KEYS_MAP = new ConcurrentHashMap<String, MetricKey>();
    private final String mName;
    private final String mDescription;
    private final MetricType mMetricType;
    private final boolean mIsClusterAggregated;
    public static final MetricKey MASTER_EDGE_CACHE_SIZE = new Builder("Master.EdgeCacheSize").setDescription("Total number of edges (inode metadata) cached. The edge cache is responsible for managing the mapping from (parentId, childName) to childId.").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_FILES_PINNED = new Builder("Master.FilesPinned").setDescription("Total number of currently pinned files").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_INODE_CACHE_SIZE = new Builder("Master.InodeCacheSize").setDescription("Total number of inodes (inode metadata) cached").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_TOTAL_PATHS = new Builder("Master.TotalPaths").setDescription("Total number of files and directory in Alluxio namespace").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_LAST_BACKUP_ENTRIES_COUNT = new Builder("Master.LastBackupEntriesCount").setDescription("The total number of entries written in the last leading master metadata backup").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_LAST_BACKUP_TIME_MS = new Builder("Master.LastBackupTimeMs").setDescription("The process time of the last backup").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_LAST_BACKUP_RESTORE_COUNT = new Builder("Master.LastBackupRestoreCount").setDescription("The total number of entries restored from backup when a leading master initializes its metadata").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_LAST_BACKUP_RESTORE_TIME_MS = new Builder("Master.LastBackupRestoreTimeMs").setDescription("The process time of the last restore from backup").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_DIRECTORIES_CREATED = new Builder("Master.DirectoriesCreated").setDescription("Total number of the succeed CreateDirectory operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILE_BLOCK_INFOS_GOT = new Builder("Master.FileBlockInfosGot").setDescription("Total number of succeed GetFileBlockInfo operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILE_INFOS_GOT = new Builder("Master.FileInfosGot").setDescription("Total number of the succeed GetFileInfo operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILES_COMPLETED = new Builder("Master.FilesCompleted").setDescription("Total number of the succeed CompleteFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILES_CREATED = new Builder("Master.FilesCreated").setDescription("Total number of the succeed CreateFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILES_FREED = new Builder("Master.FilesFreed").setDescription("Total number of succeed FreeFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FILES_PERSISTED = new Builder("Master.FilesPersisted").setDescription("Total number of successfully persisted files").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_NEW_BLOCKS_GOT = new Builder("Master.NewBlocksGot").setDescription("Total number of the succeed GetNewBlock operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_PATHS_DELETED = new Builder("Master.PathsDeleted").setDescription("Total number of the succeed Delete operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_PATHS_MOUNTED = new Builder("Master.PathsMounted").setDescription("Total number of succeed Mount operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_PATHS_RENAMED = new Builder("Master.PathsRenamed").setDescription("Total number of succeed Rename operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_PATHS_UNMOUNTED = new Builder("Master.PathsUnmounted").setDescription("Total number of succeed Unmount operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_COMPLETE_FILE_OPS = new Builder("Master.CompleteFileOps").setDescription("Total number of the CompleteFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_CREATE_DIRECTORIES_OPS = new Builder("Master.CreateDirectoryOps").setDescription("Total number of the CreateDirectory operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_CREATE_FILES_OPS = new Builder("Master.CreateFileOps").setDescription("Total number of the CreateFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_DELETE_PATHS_OPS = new Builder("Master.DeletePathOps").setDescription("Total number of the Delete operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_FREE_FILE_OPS = new Builder("Master.FreeFileOps").setDescription("Total number of FreeFile operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_GET_FILE_BLOCK_INFO_OPS = new Builder("Master.GetFileBlockInfoOps").setDescription("Total number of GetFileBlockInfo operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_GET_FILE_INFO_OPS = new Builder("Master.GetFileInfoOps").setDescription("Total number of the GetFileInfo operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_GET_NEW_BLOCK_OPS = new Builder("Master.GetNewBlockOps").setDescription("Total number of the GetNewBlock operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_LISTING_CACHE_SIZE = new Builder("Master.ListingCacheSize").setDescription("The size of master listing cache").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey MASTER_MOUNT_OPS = new Builder("Master.MountOps").setDescription("Total number of Mount operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_RENAME_PATH_OPS = new Builder("Master.RenamePathOps").setDescription("Total number of Rename operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_SET_ACL_OPS = new Builder("Master.SetAclOps").setDescription("Total number of SetAcl operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_SET_ATTRIBUTE_OPS = new Builder("Master.SetAttributeOps").setDescription("Total number of SetAttribute operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_UNMOUNT_OPS = new Builder("Master.UnmountOps").setDescription("Total number of Unmount operations").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_JOURNAL_FLUSH_FAILURE = new Builder("Master.JournalFlushFailure").setDescription("Total number of failed journal flush").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey MASTER_JOURNAL_FLUSH_TIMER = new Builder("Master.JournalFlushTimer").setDescription("The timer statistics of journal flush").setMetricType(MetricType.TIMER).build();
    public static final MetricKey MASTER_JOURNAL_GAIN_PRIMACY_TIMER = new Builder("Master.JournalGainPrimacyTimer").setDescription("The timer statistics of journal gain primacy").setMetricType(MetricType.TIMER).build();
    public static final MetricKey MASTER_UFS_JOURNAL_FAILURE_RECOVER_TIMER = new Builder("Master.UfsJournalFailureRecoverTime").setDescription("The timer statistics of ufs journal failure recover").setMetricType(MetricType.TIMER).build();
    public static final MetricKey CLUSTER_BYTES_READ_ALLUXIO = new Builder("Cluster.BytesReadAlluxio").setDescription("Total number of bytes read from Alluxio storage reported by all workers. This does not include UFS reads.").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_READ_ALLUXIO_THROUGHPUT = new Builder("Cluster.BytesReadAlluxioThroughput").setDescription("Bytes read throughput from Alluxio storage by all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_READ_DOMAIN = new Builder("Cluster.BytesReadDomain").setDescription("Total number of bytes read from Alluxio storage via domain socket reported by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_READ_DOMAIN_THROUGHPUT = new Builder("Cluster.BytesReadDomainThroughput").setDescription("Bytes read throughput from Alluxio storage via domain socket by all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_READ_LOCAL = new Builder("Cluster.BytesReadLocal").setDescription("Total number of bytes short-circuit read from local storage by all clients").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_READ_LOCAL_THROUGHPUT = new Builder("Cluster.BytesReadLocalThroughput").setDescription("Bytes throughput short-circuit read from local storage by all clients").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_READ_UFS = new Builder("Cluster.BytesReadPerUfs").setDescription("Total number of bytes read from a specific UFS by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_READ_UFS_ALL = new Builder("Cluster.BytesReadUfsAll").setDescription("Total number of bytes read from a all Alluxio UFSes by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_READ_UFS_THROUGHPUT = new Builder("Cluster.BytesReadUfsThroughput").setDescription("Bytes read throughput from all Alluxio UFSes by all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_ALLUXIO = new Builder("Cluster.BytesWrittenAlluxio").setDescription("Total number of bytes written to Alluxio storage in all workers. This does not include UFS writes").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_ALLUXIO_THROUGHPUT = new Builder("Cluster.BytesWrittenAlluxioThroughput").setDescription("Bytes write throughput to Alluxio storage in all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_DOMAIN = new Builder("Cluster.BytesWrittenDomain").setDescription("Total number of bytes written to Alluxio storage via domain socket by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_DOMAIN_THROUGHPUT = new Builder("Cluster.BytesWrittenDomainThroughput").setDescription("Throughput of bytes written to Alluxio storage via domain socket by all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_LOCAL = new Builder("Cluster.BytesWrittenLocal").setDescription("Total number of bytes short-circuit written to local storage by all clients").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_LOCAL_THROUGHPUT = new Builder("Cluster.BytesWrittenLocalThroughput").setDescription("Bytes throughput written to local storage by all clients").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_UFS = new Builder("Cluster.BytesWrittenPerUfs").setDescription("Total number of bytes written to a specific Alluxio UFS by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_UFS_ALL = new Builder("Cluster.BytesWrittenUfsAll").setDescription("Total number of bytes written to all Alluxio UFSes by all workers").setMetricType(MetricType.COUNTER).build();
    public static final MetricKey CLUSTER_BYTES_WRITTEN_UFS_THROUGHPUT = new Builder("Cluster.BytesWrittenUfsThroughput").setDescription("Bytes write throughput to all Alluxio UFSes by all workers").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_CAPACITY_TOTAL = new Builder("Cluster.CapacityTotal").setDescription("Total capacity (in bytes) on all tiers, on all workers of Alluxio").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_CAPACITY_USED = new Builder("Cluster.CapacityUsed").setDescription("Total used bytes on all tiers, on all workers of Alluxio").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_CAPACITY_FREE = new Builder("Cluster.CapacityFree").setDescription("Total free bytes on all tiers, on all workers of Alluxio").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_ROOT_UFS_CAPACITY_TOTAL = new Builder("Cluster.RootUfsCapacityTotal").setDescription("Total capacity of the Alluxio root UFS in bytes").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_ROOT_UFS_CAPACITY_USED = new Builder("Cluster.RootUfsCapacityUsed").setDescription("Used capacity of the Alluxio root UFS in bytes").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_ROOT_UFS_CAPACITY_FREE = new Builder("Cluster.RootUfsCapacityFree").setDescription("Free capacity of the Alluxio root UFS in bytes").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey CLUSTER_WORKERS = new Builder("Cluster.Workers").setDescription("Total number of active workers inside the cluster").setMetricType(MetricType.GAUGE).build();
    public static final MetricKey WORKER_ASYNC_CACHE_DUPLICATE_REQUESTS = new Builder("Worker.AsyncCacheDuplicateRequests").setDescription("Total number of duplicated async cache request received by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_ASYNC_CACHE_FAILED_BLOCKS = new Builder("Worker.AsyncCacheFailedBlocks").setDescription("Total number of async cache failed blocks in this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_ASYNC_CACHE_REMOTE_BLOCKS = new Builder("Worker.AsyncCacheRemoteBlocks").setDescription("Total number of blocks that need to be async cached from remote source").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_ASYNC_CACHE_REQUESTS = new Builder("Worker.AsyncCacheRequests").setDescription("Total number of async cache request received by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_ASYNC_CACHE_SUCCEEDED_BLOCKS = new Builder("Worker.AsyncCacheSucceededBlocks").setDescription("Total number of async cache succeeded blocks in this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_ASYNC_CACHE_UFS_BLOCKS = new Builder("Worker.AsyncCacheUfsBlocks").setDescription("Total number of blocks that need to be async cached from local source").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_ACCESSED = new Builder("Worker.BlocksAccessed").setDescription("Total number of times any one of the blocks in this worker is accessed.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_CACHED = new Builder("Worker.BlocksCached").setDescription("Total number of blocks used for caching data in an Alluxio worker").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_CANCELLED = new Builder("Worker.BlocksCancelled").setDescription("Total number of aborted temporary blocks in this worker.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_DELETED = new Builder("Worker.BlocksDeleted").setDescription("Total number of deleted blocks in this worker by external requests.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_EVICTED = new Builder("Worker.BlocksEvicted").setDescription("Total number of evicted blocks in this worker.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_LOST = new Builder("Worker.BlocksLost").setDescription("Total number of lost blocks in this worker.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BLOCKS_PROMOTED = new Builder("Worker.BlocksPromoted").setDescription("Total number of times any one of the blocks in this worker moved to a new tier.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_READ_ALLUXIO = new Builder("Worker.BytesReadAlluxio").setDescription("Total number of bytes read from Alluxio storage managed by this worker. This does not include UFS reads.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_READ_ALLUXIO_THROUGHPUT = new Builder("Worker.BytesReadAlluxioThroughput").setDescription("Bytes read throughput from Alluxio storage by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_READ_DOMAIN = new Builder("Worker.BytesReadDomain").setDescription("Total number of bytes read from Alluxio storage via domain socket by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_READ_DOMAIN_THROUGHPUT = new Builder("Worker.BytesReadDomainThroughput").setDescription("Bytes read throughput from Alluxio storage via domain socket by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_READ_UFS = new Builder("Worker.BytesReadPerUfs").setDescription("Total number of bytes read from a specific Alluxio UFS by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_READ_UFS_THROUGHPUT = new Builder("Worker.BytesReadUfsThroughput").setDescription("Bytes read throughput from all Alluxio UFSes by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_ALLUXIO = new Builder("Worker.BytesWrittenAlluxio").setDescription("Total number of bytes written to Alluxio storage by this worker. This does not include UFS writes").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_ALLUXIO_THROUGHPUT = new Builder("Worker.BytesWrittenAlluxioThroughput").setDescription("Bytes write throughput to Alluxio storage by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_DOMAIN = new Builder("Worker.BytesWrittenDomain").setDescription("Total number of bytes written to Alluxio storage via domain socket by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_DOMAIN_THROUGHPUT = new Builder("Worker.BytesWrittenDomainThroughput").setDescription("Throughput of bytes written to Alluxio storage via domain socket by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_UFS = new Builder("Worker.BytesWrittenPerUfs").setDescription("Total number of bytes written to a specific Alluxio UFS by this worker").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey WORKER_BYTES_WRITTEN_UFS_THROUGHPUT = new Builder("Worker.BytesWrittenUfsThroughput").setDescription("Bytes write throughput to all Alluxio UFSes by this worker").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_CAPACITY_TOTAL = new Builder("Worker.CapacityTotal").setDescription("Total capacity (in bytes) on all tiers of a specific Alluxio worker").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_CAPACITY_USED = new Builder("Worker.CapacityUsed").setDescription("Total used bytes on all tiers of a specific Alluxio worker").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey WORKER_CAPACITY_FREE = new Builder("Worker.CapacityFree").setDescription("Total free bytes on all tiers of a specific Alluxio worker").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_BYTES_READ_LOCAL = new Builder("Client.BytesReadLocal").setDescription("Total number of bytes short-circuit read from local storage by this client").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey CLIENT_BYTES_READ_LOCAL_THROUGHPUT = new Builder("Client.BytesReadLocalThroughput").setDescription("Bytes throughput short-circuit read from local storage by this client").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_BYTES_WRITTEN_LOCAL = new Builder("Client.BytesWrittenLocal").setDescription("Total number of bytes short-circuit written to local storage by this client").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey CLIENT_BYTES_WRITTEN_LOCAL_THROUGHPUT = new Builder("Client.BytesWrittenLocalThroughput").setDescription("Bytes throughput short-circuit written to local storage by this client").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_BYTES_WRITTEN_UFS = new Builder("Client.BytesWrittenUfs").setDescription("Total number of bytes write to Alluxio UFS by this client").setMetricType(MetricType.COUNTER).setIsClusterAggregated(true).build();
    public static final MetricKey CLIENT_CACHE_BYTES_READ_CACHE = new Builder("Client.CacheBytesReadCache").setDescription("Total number of bytes read from the client cache.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_BYTES_READ_EXTERNAL = new Builder("Client.CacheBytesReadExternal").setDescription("Total number of bytes read from external storage due to a cache miss on the client cache.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL = new Builder("Client.CacheBytesRequestedExternal").setDescription("Total number of bytes the user requested to read which resulted in a cache miss. This number may be smaller than Client.CacheBytesReadExternal due to chunk reads.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_BYTES_EVICTED = new Builder("Client.CacheBytesEvicted").setDescription("Total number of bytes evicted from the client cache.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PAGES = new Builder("Client.CachePages").setDescription("Total number of pages in the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PAGES_EVICTED = new Builder("Client.CachePagesEvicted").setDescription("Total number of pages evicted from the client cache.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_BYTES_WRITTEN_CACHE = new Builder("Client.CacheBytesWrittenCache").setDescription("Total number of bytes written to the client cache.").setMetricType(MetricType.METER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_HIT_RATE = new Builder("Client.CacheHitRate").setDescription("Cache hit rate: (# bytes read from cache) / (# bytes requested).").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_SPACE_AVAILABLE = new Builder("Client.CacheSpaceAvailable").setDescription("Amount of bytes available in the client cache.").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_SPACE_USED = new Builder("Client.CacheSpaceUsed").setDescription("Amount of bytes used by the client cache.").setMetricType(MetricType.GAUGE).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_SPACE_USED_COUNT = new Builder("Client.CacheSpaceUsedCount").setDescription("Amount of bytes used by the client cache as a counter.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_UNREMOVABLE_FILES = new Builder("Client.CacheUnremovableFiles").setDescription("Amount of bytes unusable managed by the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_CREATE_ERRORS = new Builder("Client.CacheCreateErrors").setDescription("Number of failures when creating a cache in the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_DELETE_ERRORS = new Builder("Client.CacheDeleteErrors").setDescription("Number of failures when deleting cached data in the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_DELETE_NON_EXISTING_PAGE_ERRORS = new Builder("Client.CacheDeleteNonExistingPageErrors").setDescription("Number of failures when deleting pages due to absence.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_DELETE_NOT_READY_ERRORS = new Builder("Client.CacheDeleteNotReadyErrors").setDescription("Number of failures when  when cache is not ready to delete pages.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_DELETE_STORE_DELETE_ERRORS = new Builder("Client.CacheDeleteStoreDeleteErrors").setDescription("Number of failures when deleting pages due to failed delete in page stores.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_GET_ERRORS = new Builder("Client.CacheGetErrors").setDescription("Number of failures when getting cached data in the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_GET_NOT_READY_ERRORS = new Builder("Client.CacheGetNotReadyErrors").setDescription("Number of failures when cache is not ready to get pages.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_GET_STORE_READ_ERRORS = new Builder("Client.CacheGetStoreReadErrors").setDescription("Number of failures when getting cached data in the client cache due to failed read from page stores.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_CLEANUP_GET_ERRORS = new Builder("Client.CacheCleanupGetErrors").setDescription("Number of failures when cleaning up a failed cache read.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_CLEANUP_PUT_ERRORS = new Builder("Client.CacheCleanupPutErrors").setDescription("Number of failures when cleaning up a failed cache write.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_ERRORS = new Builder("Client.CachePutErrors").setDescription("Number of failures when putting cached data in the client cache.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_ASYNC_REJECTION_ERRORS = new Builder("Client.CachePutAsyncRejectionErrors").setDescription("Number of failures when putting cached data in the client cache due to failed injection to async write queue.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_EVICTION_ERRORS = new Builder("Client.CachePutEvictionErrors").setDescription("Number of failures when putting cached data in the client cache due to failed eviction.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_BENIGN_RACING_ERRORS = new Builder("Client.CachePutBenignRacingErrors").setDescription("Number of failures when adding pages due to racing eviction. This error is benign.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_NOT_READY_ERRORS = new Builder("Client.CachePutNotReadyErrors").setDescription("Number of failures when cache is not ready to add pages.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_STORE_DELETE_ERRORS = new Builder("Client.CachePutStoreDeleteErrors").setDescription("Number of failures when putting cached data in the client cache due to failed deletes in page store.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_PUT_STORE_WRITE_ERRORS = new Builder("Client.CachePutStoreWriteErrors").setDescription("Number of failures when putting cached data in the client cache due to failed writes to page store.").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();
    public static final MetricKey CLIENT_CACHE_STATE = new Builder("Client.CacheState").setDescription("State of the cache: 0 (NOT_IN_USE), 1 (READ_ONLY) and 2 (READ_WRITE)").setMetricType(MetricType.COUNTER).setIsClusterAggregated(false).build();

    private MetricKey(String name, String description, MetricType metricType, boolean isClusterAggregated) {
        this.mName = Preconditions.checkNotNull(name, "name");
        this.mDescription = Strings.isNullOrEmpty(description) ? "N/A" : description;
        this.mMetricType = metricType;
        this.mIsClusterAggregated = isClusterAggregated;
    }

    private MetricKey(String name) {
        this(name, null, MetricType.GAUGE, false);
    }

    public static boolean isValid(String name) {
        return METRIC_KEYS_MAP.containsKey(name);
    }

    public static MetricKey fromString(String name) {
        MetricKey key = METRIC_KEYS_MAP.get(name);
        if (key != null) {
            return key;
        }
        throw new IllegalArgumentException(ExceptionMessage.INVALID_METRIC_KEY.getMessage(name));
    }

    public static Collection<? extends MetricKey> allMetricKeys() {
        return Sets.newHashSet(METRIC_KEYS_MAP.values());
    }

    public static Set<MetricKey> allShouldReportMetricKeys(MetricsSystem.InstanceType instanceType) {
        HashSet<MetricKey> shouldReportMetrics = new HashSet<MetricKey>();
        for (Map.Entry<String, MetricKey> entry : METRIC_KEYS_MAP.entrySet()) {
            if (!entry.getKey().startsWith(instanceType.toString()) || !entry.getValue().isClusterAggregated()) continue;
            shouldReportMetrics.add(entry.getValue());
        }
        return shouldReportMetrics;
    }

    public String getName() {
        return this.mName;
    }

    public String getMetricName() {
        String[] pieces = this.mName.split("\\.");
        if (pieces.length <= 1) {
            return this.mName;
        }
        return pieces[1];
    }

    public String getDescription() {
        return this.mDescription;
    }

    public MetricType getMetricType() {
        return this.mMetricType;
    }

    public boolean isClusterAggregated() {
        return this.mIsClusterAggregated;
    }

    @VisibleForTesting
    public static boolean register(MetricKey key) {
        String name = key.getName();
        if (METRIC_KEYS_MAP.containsKey(name)) {
            return false;
        }
        METRIC_KEYS_MAP.put(name, key);
        return true;
    }

    @VisibleForTesting
    public static void unregister(MetricKey key) {
        METRIC_KEYS_MAP.remove(key.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricKey)) {
            return false;
        }
        MetricKey that = (MetricKey)o;
        return Objects.equal(this.mName, that.mName);
    }

    public int hashCode() {
        return Objects.hashCode(this.mName);
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int compareTo(MetricKey o) {
        return this.mName.compareTo(o.mName);
    }

    @ThreadSafe
    public static final class Name {
        public static final String MASTER_EDGE_CACHE_SIZE = "Master.EdgeCacheSize";
        public static final String MASTER_FILES_PINNED = "Master.FilesPinned";
        public static final String MASTER_INODE_CACHE_SIZE = "Master.InodeCacheSize";
        public static final String MASTER_TOTAL_PATHS = "Master.TotalPaths";
        public static final String MASTER_LAST_BACKUP_ENTRIES_COUNT = "Master.LastBackupEntriesCount";
        public static final String MASTER_LAST_BACKUP_RESTORE_COUNT = "Master.LastBackupRestoreCount";
        public static final String MASTER_LAST_BACKUP_TIME_MS = "Master.LastBackupTimeMs";
        public static final String MASTER_LAST_BACKUP_RESTORE_TIME_MS = "Master.LastBackupRestoreTimeMs";
        public static final String MASTER_DIRECTORIES_CREATED = "Master.DirectoriesCreated";
        public static final String MASTER_FILE_BLOCK_INFOS_GOT = "Master.FileBlockInfosGot";
        public static final String MASTER_FILE_INFOS_GOT = "Master.FileInfosGot";
        public static final String MASTER_FILES_COMPLETED = "Master.FilesCompleted";
        public static final String MASTER_FILES_CREATED = "Master.FilesCreated";
        public static final String MASTER_FILES_FREED = "Master.FilesFreed";
        public static final String MASTER_FILES_PERSISTED = "Master.FilesPersisted";
        public static final String MASTER_NEW_BLOCKS_GOT = "Master.NewBlocksGot";
        public static final String MASTER_PATHS_DELETED = "Master.PathsDeleted";
        public static final String MASTER_PATHS_MOUNTED = "Master.PathsMounted";
        public static final String MASTER_PATHS_RENAMED = "Master.PathsRenamed";
        public static final String MASTER_PATHS_UNMOUNTED = "Master.PathsUnmounted";
        public static final String MASTER_COMPLETE_FILE_OPS = "Master.CompleteFileOps";
        public static final String MASTER_CREATE_DIRECTORIES_OPS = "Master.CreateDirectoryOps";
        public static final String MASTER_CREATE_FILES_OPS = "Master.CreateFileOps";
        public static final String MASTER_DELETE_PATHS_OPS = "Master.DeletePathOps";
        public static final String MASTER_FREE_FILE_OPS = "Master.FreeFileOps";
        public static final String MASTER_GET_FILE_BLOCK_INFO_OPS = "Master.GetFileBlockInfoOps";
        public static final String MASTER_GET_FILE_INFO_OPS = "Master.GetFileInfoOps";
        public static final String MASTER_GET_NEW_BLOCK_OPS = "Master.GetNewBlockOps";
        public static final String MASTER_LISTING_CACHE_SIZE = "Master.ListingCacheSize";
        public static final String MASTER_MOUNT_OPS = "Master.MountOps";
        public static final String MASTER_RENAME_PATH_OPS = "Master.RenamePathOps";
        public static final String MASTER_SET_ACL_OPS = "Master.SetAclOps";
        public static final String MASTER_SET_ATTRIBUTE_OPS = "Master.SetAttributeOps";
        public static final String MASTER_UNMOUNT_OPS = "Master.UnmountOps";
        public static final String MASTER_JOURNAL_FLUSH_FAILURE = "Master.JournalFlushFailure";
        public static final String MASTER_JOURNAL_FLUSH_TIMER = "Master.JournalFlushTimer";
        public static final String MASTER_JOURNAL_GAIN_PRIMACY_TIMER = "Master.JournalGainPrimacyTimer";
        public static final String MASTER_UFS_JOURNAL_FAILURE_RECOVER_TIMER = "Master.UfsJournalFailureRecoverTime";
        public static final String CLUSTER_BYTES_READ_LOCAL = "Cluster.BytesReadLocal";
        public static final String CLUSTER_BYTES_READ_LOCAL_THROUGHPUT = "Cluster.BytesReadLocalThroughput";
        public static final String CLUSTER_BYTES_READ_ALLUXIO = "Cluster.BytesReadAlluxio";
        public static final String CLUSTER_BYTES_READ_ALLUXIO_THROUGHPUT = "Cluster.BytesReadAlluxioThroughput";
        public static final String CLUSTER_BYTES_READ_DOMAIN = "Cluster.BytesReadDomain";
        public static final String CLUSTER_BYTES_READ_DOMAIN_THROUGHPUT = "Cluster.BytesReadDomainThroughput";
        public static final String CLUSTER_BYTES_READ_UFS = "Cluster.BytesReadPerUfs";
        public static final String CLUSTER_BYTES_READ_UFS_ALL = "Cluster.BytesReadUfsAll";
        public static final String CLUSTER_BYTES_READ_UFS_THROUGHPUT = "Cluster.BytesReadUfsThroughput";
        public static final String CLUSTER_BYTES_WRITTEN_ALLUXIO = "Cluster.BytesWrittenAlluxio";
        public static final String CLUSTER_BYTES_WRITTEN_ALLUXIO_THROUGHPUT = "Cluster.BytesWrittenAlluxioThroughput";
        public static final String CLUSTER_BYTES_WRITTEN_DOMAIN = "Cluster.BytesWrittenDomain";
        public static final String CLUSTER_BYTES_WRITTEN_DOMAIN_THROUGHPUT = "Cluster.BytesWrittenDomainThroughput";
        public static final String CLUSTER_BYTES_WRITTEN_LOCAL = "Cluster.BytesWrittenLocal";
        public static final String CLUSTER_BYTES_WRITTEN_LOCAL_THROUGHPUT = "Cluster.BytesWrittenLocalThroughput";
        public static final String CLUSTER_BYTES_WRITTEN_UFS = "Cluster.BytesWrittenPerUfs";
        public static final String CLUSTER_BYTES_WRITTEN_UFS_ALL = "Cluster.BytesWrittenUfsAll";
        public static final String CLUSTER_BYTES_WRITTEN_UFS_THROUGHPUT = "Cluster.BytesWrittenUfsThroughput";
        public static final String CLUSTER_CAPACITY_TOTAL = "Cluster.CapacityTotal";
        public static final String CLUSTER_CAPACITY_USED = "Cluster.CapacityUsed";
        public static final String CLUSTER_CAPACITY_FREE = "Cluster.CapacityFree";
        public static final String CLUSTER_ROOT_UFS_CAPACITY_TOTAL = "Cluster.RootUfsCapacityTotal";
        public static final String CLUSTER_ROOT_UFS_CAPACITY_USED = "Cluster.RootUfsCapacityUsed";
        public static final String CLUSTER_ROOT_UFS_CAPACITY_FREE = "Cluster.RootUfsCapacityFree";
        public static final String CLUSTER_WORKERS = "Cluster.Workers";
        public static final String WORKER_ASYNC_CACHE_DUPLICATE_REQUESTS = "Worker.AsyncCacheDuplicateRequests";
        public static final String WORKER_ASYNC_CACHE_FAILED_BLOCKS = "Worker.AsyncCacheFailedBlocks";
        public static final String WORKER_ASYNC_CACHE_REMOTE_BLOCKS = "Worker.AsyncCacheRemoteBlocks";
        public static final String WORKER_ASYNC_CACHE_REQUESTS = "Worker.AsyncCacheRequests";
        public static final String WORKER_ASYNC_CACHE_SUCCEEDED_BLOCKS = "Worker.AsyncCacheSucceededBlocks";
        public static final String WORKER_ASYNC_CACHE_UFS_BLOCKS = "Worker.AsyncCacheUfsBlocks";
        public static final String WORKER_BLOCKS_ACCESSED = "Worker.BlocksAccessed";
        public static final String WORKER_BLOCKS_CACHED = "Worker.BlocksCached";
        public static final String WORKER_BLOCKS_CANCELLED = "Worker.BlocksCancelled";
        public static final String WORKER_BLOCKS_DELETED = "Worker.BlocksDeleted";
        public static final String WORKER_BLOCKS_EVICTED = "Worker.BlocksEvicted";
        public static final String WORKER_BLOCKS_LOST = "Worker.BlocksLost";
        public static final String WORKER_BLOCKS_PROMOTED = "Worker.BlocksPromoted";
        public static final String WORKER_BYTES_READ_ALLUXIO = "Worker.BytesReadAlluxio";
        public static final String WORKER_BYTES_READ_ALLUXIO_THROUGHPUT = "Worker.BytesReadAlluxioThroughput";
        public static final String WORKER_BYTES_WRITTEN_ALLUXIO = "Worker.BytesWrittenAlluxio";
        public static final String WORKER_BYTES_WRITTEN_ALLUXIO_THROUGHPUT = "Worker.BytesWrittenAlluxioThroughput";
        public static final String WORKER_BYTES_READ_DOMAIN = "Worker.BytesReadDomain";
        public static final String WORKER_BYTES_READ_DOMAIN_THROUGHPUT = "Worker.BytesReadDomainThroughput";
        public static final String WORKER_BYTES_WRITTEN_DOMAIN = "Worker.BytesWrittenDomain";
        public static final String WORKER_BYTES_WRITTEN_DOMAIN_THROUGHPUT = "Worker.BytesWrittenDomainThroughput";
        public static final String WORKER_BYTES_READ_UFS = "Worker.BytesReadPerUfs";
        public static final String WORKER_BYTES_READ_UFS_THROUGHPUT = "Worker.BytesReadUfsThroughput";
        public static final String WORKER_BYTES_WRITTEN_UFS = "Worker.BytesWrittenPerUfs";
        public static final String WORKER_BYTES_WRITTEN_UFS_THROUGHPUT = "Worker.BytesWrittenUfsThroughput";
        public static final String WORKER_CAPACITY_TOTAL = "Worker.CapacityTotal";
        public static final String WORKER_CAPACITY_USED = "Worker.CapacityUsed";
        public static final String WORKER_CAPACITY_FREE = "Worker.CapacityFree";
        public static final String CLIENT_BYTES_READ_LOCAL = "Client.BytesReadLocal";
        public static final String CLIENT_BYTES_READ_LOCAL_THROUGHPUT = "Client.BytesReadLocalThroughput";
        public static final String CLIENT_BYTES_WRITTEN_LOCAL = "Client.BytesWrittenLocal";
        public static final String CLIENT_BYTES_WRITTEN_LOCAL_THROUGHPUT = "Client.BytesWrittenLocalThroughput";
        public static final String CLIENT_BYTES_WRITTEN_UFS = "Client.BytesWrittenUfs";
        public static final String CLIENT_CACHE_BYTES_READ_CACHE = "Client.CacheBytesReadCache";
        public static final String CLIENT_CACHE_BYTES_READ_EXTERNAL = "Client.CacheBytesReadExternal";
        public static final String CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL = "Client.CacheBytesRequestedExternal";
        public static final String CLIENT_CACHE_BYTES_EVICTED = "Client.CacheBytesEvicted";
        public static final String CLIENT_CACHE_PAGES = "Client.CachePages";
        public static final String CLIENT_CACHE_PAGES_EVICTED = "Client.CachePagesEvicted";
        public static final String CLIENT_CACHE_BYTES_WRITTEN_CACHE = "Client.CacheBytesWrittenCache";
        public static final String CLIENT_CACHE_HIT_RATE = "Client.CacheHitRate";
        public static final String CLIENT_CACHE_SPACE_AVAILABLE = "Client.CacheSpaceAvailable";
        public static final String CLIENT_CACHE_SPACE_USED = "Client.CacheSpaceUsed";
        public static final String CLIENT_CACHE_SPACE_USED_COUNT = "Client.CacheSpaceUsedCount";
        public static final String CLIENT_CACHE_CLEANUP_GET_ERRORS = "Client.CacheCleanupGetErrors";
        public static final String CLIENT_CACHE_CLEANUP_PUT_ERRORS = "Client.CacheCleanupPutErrors";
        public static final String CLIENT_CACHE_CREATE_ERRORS = "Client.CacheCreateErrors";
        public static final String CLIENT_CACHE_DELETE_ERRORS = "Client.CacheDeleteErrors";
        public static final String CLIENT_CACHE_DELETE_NON_EXISTING_PAGE_ERRORS = "Client.CacheDeleteNonExistingPageErrors";
        public static final String CLIENT_CACHE_DELETE_NOT_READY_ERRORS = "Client.CacheDeleteNotReadyErrors";
        public static final String CLIENT_CACHE_DELETE_STORE_DELETE_ERRORS = "Client.CacheDeleteStoreDeleteErrors";
        public static final String CLIENT_CACHE_GET_ERRORS = "Client.CacheGetErrors";
        public static final String CLIENT_CACHE_GET_NOT_READY_ERRORS = "Client.CacheGetNotReadyErrors";
        public static final String CLIENT_CACHE_GET_STORE_READ_ERRORS = "Client.CacheGetStoreReadErrors";
        public static final String CLIENT_CACHE_PUT_ERRORS = "Client.CachePutErrors";
        public static final String CLIENT_CACHE_PUT_ASYNC_REJECTION_ERRORS = "Client.CachePutAsyncRejectionErrors";
        public static final String CLIENT_CACHE_PUT_EVICTION_ERRORS = "Client.CachePutEvictionErrors";
        public static final String CLIENT_CACHE_PUT_BENIGN_RACING_ERRORS = "Client.CachePutBenignRacingErrors";
        public static final String CLIENT_CACHE_PUT_NOT_READY_ERRORS = "Client.CachePutNotReadyErrors";
        public static final String CLIENT_CACHE_PUT_STORE_DELETE_ERRORS = "Client.CachePutStoreDeleteErrors";
        public static final String CLIENT_CACHE_PUT_STORE_WRITE_ERRORS = "Client.CachePutStoreWriteErrors";
        public static final String CLIENT_CACHE_STATE = "Client.CacheState";
        public static final String CLIENT_CACHE_UNREMOVABLE_FILES = "Client.CacheUnremovableFiles";

        private Name() {
        }
    }

    public static final class Builder {
        private String mName;
        private String mDescription;
        private boolean mIsClusterAggregated;
        private MetricType mMetricType = MetricType.GAUGE;

        public Builder(String name) {
            this.mName = name;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setIsClusterAggregated(boolean isClusterAggregated) {
            this.mIsClusterAggregated = isClusterAggregated;
            return this;
        }

        public Builder setMetricType(MetricType metricType) {
            this.mMetricType = metricType;
            return this;
        }

        public MetricKey build() {
            MetricKey key = new MetricKey(this.mName, this.mDescription, this.mMetricType, this.mIsClusterAggregated);
            Preconditions.checkState(MetricKey.register(key), "Cannot register existing metric \"%s\"", (Object)this.mName);
            return key;
        }
    }
}

