/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.ClientContext;
import alluxio.client.metrics.RetryHandlingMetricsMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ClientMetrics;
import alluxio.grpc.Metric;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.logging.SamplingLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClientMasterSync {
    private static final Logger SAMPLING_LOG = new SamplingLogger(LoggerFactory.getLogger(ClientMasterSync.class), 30000L);
    private final String mApplicationId;
    private final MasterInquireClient mInquireClient;
    private final ClientContext mContext;
    private RetryHandlingMetricsMasterClient mMasterClient;

    public ClientMasterSync(String appId, ClientContext ctx, MasterInquireClient inquireClient) {
        this.mApplicationId = Preconditions.checkNotNull(appId);
        this.mInquireClient = inquireClient;
        this.mContext = ctx;
    }

    public synchronized void heartbeat() {
        if (this.mMasterClient == null) {
            if (this.loadConf()) {
                this.mMasterClient = new RetryHandlingMetricsMasterClient(MasterClientContext.newBuilder(this.mContext).setMasterInquireClient(this.mInquireClient).build());
            } else {
                return;
            }
        }
        ArrayList<ClientMetrics> fsClientMetrics = new ArrayList<ClientMetrics>();
        List<Metric> metrics = MetricsSystem.reportClientMetrics();
        if (metrics.size() == 0) {
            return;
        }
        fsClientMetrics.add(ClientMetrics.newBuilder().setSource(this.mApplicationId).addAllMetrics(metrics).build());
        try {
            this.mMasterClient.heartbeat(fsClientMetrics);
        }
        catch (IOException e) {
            SAMPLING_LOG.warn("Failed to send metrics to master: {}", (Object)e.toString());
        }
    }

    public synchronized void close() {
        if (this.mMasterClient != null) {
            this.mMasterClient.close();
        }
    }

    private boolean loadConf() {
        try {
            InetSocketAddress masterAddr = this.mInquireClient.getPrimaryRpcAddress();
            this.mContext.loadConf(masterAddr, true, false);
        }
        catch (UnavailableException e) {
            SAMPLING_LOG.error("Failed to get master address during initialization: {}", (Object)e.toString());
            return false;
        }
        catch (AlluxioStatusException ae) {
            SAMPLING_LOG.error("Failed to load configuration from meta master during initialization: {}", (Object)ae.toString());
            return false;
        }
        return true;
    }
}

