/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.LocalCacheManager;
import alluxio.client.file.cache.NoExceptionCacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.conf.AlluxioConfiguration;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager
extends AutoCloseable {
    public boolean put(PageId var1, byte[] var2);

    default public int get(PageId pageId, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        return this.get(pageId, 0, bytesToRead, buffer, offsetInBuffer);
    }

    public int get(PageId var1, int var2, int var3, byte[] var4, int var5);

    public boolean delete(PageId var1);

    public State state();

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static final Lock CACHE_INIT_LOCK = new ReentrantLock();
        @GuardedBy(value="CACHE_INIT_LOCK")
        private static final AtomicReference<CacheManager> CACHE_MANAGER = new AtomicReference();

        @Nullable
        public static CacheManager get(AlluxioConfiguration conf) throws IOException {
            if (CACHE_MANAGER.get() == null && CACHE_INIT_LOCK.tryLock()) {
                try {
                    if (CACHE_MANAGER.get() == null) {
                        CACHE_MANAGER.set(Factory.create(conf));
                    }
                }
                catch (IOException e) {
                    Metrics.CREATE_ERRORS.inc();
                    throw new IOException("Failed to create CacheManager", e);
                }
                finally {
                    CACHE_INIT_LOCK.unlock();
                }
            }
            return CACHE_MANAGER.get();
        }

        static CacheManager create(AlluxioConfiguration conf) throws IOException {
            try {
                return new NoExceptionCacheManager(LocalCacheManager.create(conf));
            }
            catch (IOException e) {
                Metrics.CREATE_ERRORS.inc();
                LOG.error("Failed to create CacheManager", (Throwable)e);
                throw e;
            }
        }

        static void clear() {
            try (LockResource r = new LockResource(CACHE_INIT_LOCK);){
                CacheManager manager = CACHE_MANAGER.getAndSet(null);
                if (manager != null) {
                    manager.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to close CacheManager: {}", (Object)e.toString());
            }
        }

        private Factory() {
        }

        private static final class Metrics {
            private static final Counter CREATE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CREATE_ERRORS.getName());

            private Metrics() {
            }
        }
    }

    public static enum State {
        NOT_IN_USE(0),
        READ_ONLY(1),
        READ_WRITE(2);

        private final int mValue;

        private State(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

