/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.master.MasterInquireClient;
import alluxio.security.authorization.AclEntry;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.uri.Authority;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;

@ThreadSafe
public class FileSystemCache {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final HashMap<Key, Value> mCacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem get(Key key) {
        Object object = this.mLock;
        synchronized (object) {
            FileSystem fs;
            Value value = this.mCacheMap.get(key);
            if (value == null) {
                fs = FileSystem.Factory.create(FileSystemContext.create(key.mSubject, key.mConf));
                this.mCacheMap.put(key, new Value(fs, 1));
            } else {
                fs = value.mFileSystem;
                value.mRefCount.getAndIncrement();
            }
            return new InstanceCachingFileSystem(fs, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void purge() {
        Object object = this.mLock;
        synchronized (object) {
            new HashSet<Value>(this.mCacheMap.values()).forEach(value -> {
                try {
                    value.mRefCount.set(1);
                    value.mFileSystem.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public class InstanceCachingFileSystem
    extends DelegatingFileSystem {
        public static final String CLOSED_FS_ERROR_MESSAGE = "FileSystem already closed";
        final Key mKey;
        boolean mClosed;

        InstanceCachingFileSystem(FileSystem fs, Key key) {
            super(fs);
            this.mClosed = false;
            this.mKey = key;
        }

        @Override
        public boolean isClosed() {
            return this.mClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.mClosed) {
                this.mClosed = true;
                Object object = FileSystemCache.this.mLock;
                synchronized (object) {
                    Value value = (Value)FileSystemCache.this.mCacheMap.get(this.mKey);
                    Preconditions.checkNotNull(value);
                    if (value.mRefCount.decrementAndGet() == 0) {
                        FileSystemCache.this.mCacheMap.remove(this.mKey);
                        super.close();
                    }
                }
            }
        }

        @Override
        public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.createDirectory(path, options);
        }

        @Override
        public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.createFile(path, options);
        }

        @Override
        public void delete(AlluxioURI path, DeletePOptions options) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.delete(path, options);
        }

        @Override
        public boolean exists(AlluxioURI path, ExistsPOptions options) throws InvalidPathException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.exists(path, options);
        }

        @Override
        public void free(AlluxioURI path, FreePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.free(path, options);
        }

        @Override
        public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.getBlockLocations(path);
        }

        @Override
        public AlluxioConfiguration getConf() {
            return super.getConf();
        }

        @Override
        public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.getStatus(path, options);
        }

        @Override
        public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.listStatus(path, options);
        }

        @Override
        public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath, MountPOptions options) throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.mount(alluxioPath, ufsPath, options);
        }

        @Override
        public void updateMount(AlluxioURI alluxioPath, MountPOptions options) throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.updateMount(alluxioPath, options);
        }

        @Override
        public Map<String, MountPointInfo> getMountTable() throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.getMountTable();
        }

        @Override
        public List<SyncPointInfo> getSyncPathList() throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.getSyncPathList();
        }

        @Override
        public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.openFile(path, options);
        }

        @Override
        public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.openFile(status, options);
        }

        @Override
        public void persist(AlluxioURI path, ScheduleAsyncPersistencePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.persist(path, options);
        }

        @Override
        public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.rename(src, dst, options);
        }

        @Override
        public AlluxioURI reverseResolve(AlluxioURI ufsUri) throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            return super.reverseResolve(ufsUri);
        }

        @Override
        public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.setAcl(path, action, entries, options);
        }

        @Override
        public void startSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.startSync(path);
        }

        @Override
        public void stopSync(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.stopSync(path);
        }

        @Override
        public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.setAttribute(path, options);
        }

        @Override
        public void unmount(AlluxioURI path, UnmountPOptions options) throws IOException, AlluxioException {
            if (this.mClosed) {
                throw new IOException(CLOSED_FS_ERROR_MESSAGE);
            }
            super.unmount(path, options);
        }
    }

    public static class Value {
        final FileSystem mFileSystem;
        final AtomicInteger mRefCount;

        public Value(FileSystem fileSystem, int count) {
            this.mFileSystem = fileSystem;
            this.mRefCount = new AtomicInteger(count);
        }
    }

    public static class Key {
        final Subject mSubject;
        final Authority mAuth;
        final AlluxioConfiguration mConf;

        public Key(Subject subject, AlluxioConfiguration conf) {
            this.mConf = conf;
            this.mSubject = subject;
            this.mAuth = MasterInquireClient.Factory.getConnectDetails(conf).toAuthority();
        }

        public int hashCode() {
            return Objects.hash(this.mSubject, this.mAuth);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)o;
            return Objects.equals(this.mSubject, otherKey.mSubject) && Objects.equals(this.mAuth, otherKey.mAuth);
        }
    }
}

