/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Preconditions;
import io.airlift.http.client.GatheringByteArrayInputStream;
import io.airlift.http.client.ResponseTooLargeException;
import io.airlift.http.client.jetty.JettyResponseFuture;
import io.airlift.units.DataSize;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpHeader;

@ThreadSafe
class BufferingResponseListener
extends Response.Listener.Adapter {
    private static final long BUFFER_MAX_BYTES = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private static final long BUFFER_MIN_BYTES = new DataSize(1.0, DataSize.Unit.KILOBYTE).toBytes();
    private final JettyResponseFuture<?, ?> future;
    private final int maxLength;
    @GuardedBy(value="this")
    private byte[] currentBuffer = new byte[0];
    @GuardedBy(value="this")
    private int currentBufferPosition;
    @GuardedBy(value="this")
    private List<byte[]> buffers = new ArrayList<byte[]>();
    @GuardedBy(value="this")
    private long size;

    public BufferingResponseListener(JettyResponseFuture<?, ?> future, int maxLength) {
        this.future = Objects.requireNonNull(future, "future is null");
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be greater than zero");
        this.maxLength = maxLength;
    }

    public synchronized void onHeaders(Response response) {
        long length = response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (length > (long)this.maxLength) {
            response.abort((Throwable)new ResponseTooLargeException());
        }
    }

    public synchronized void onContent(Response response, ByteBuffer content) {
        int length = content.remaining();
        this.size += (long)length;
        if (this.size > (long)this.maxLength) {
            response.abort((Throwable)new ResponseTooLargeException());
            return;
        }
        while (length > 0) {
            if (this.currentBufferPosition >= this.currentBuffer.length) {
                this.allocateCurrentBuffer();
            }
            int readLength = Math.min(length, this.currentBuffer.length - this.currentBufferPosition);
            content.get(this.currentBuffer, this.currentBufferPosition, readLength);
            length -= readLength;
            this.currentBufferPosition += readLength;
        }
    }

    public synchronized void onComplete(Result result) {
        Throwable throwable = result.getFailure();
        if (throwable != null) {
            this.future.failed(throwable);
        } else {
            this.currentBuffer = new byte[0];
            this.currentBufferPosition = 0;
            this.future.completed(result.getResponse(), new GatheringByteArrayInputStream(this.buffers, this.size));
            this.buffers = new ArrayList<byte[]>();
            this.size = 0L;
        }
    }

    private synchronized void allocateCurrentBuffer() {
        Preconditions.checkState((this.currentBufferPosition >= this.currentBuffer.length ? 1 : 0) != 0, (Object)"there is still remaining space in currentBuffer");
        this.currentBuffer = new byte[(int)Math.min(BUFFER_MAX_BYTES, Math.max((long)(2 * this.currentBuffer.length), BUFFER_MIN_BYTES))];
        this.buffers.add(this.currentBuffer);
        this.currentBufferPosition = 0;
    }
}

