/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.functions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class TrinoKeywordsConverter {
    public static final Map<String, Boolean> RESERVED_KEYWORDS = ImmutableMap.builder().put((Object)"ALTER", (Object)Boolean.FALSE).put((Object)"AND", (Object)Boolean.FALSE).put((Object)"AS", (Object)Boolean.FALSE).put((Object)"BETWEEN", (Object)Boolean.FALSE).put((Object)"BY", (Object)Boolean.FALSE).put((Object)"CASE", (Object)Boolean.FALSE).put((Object)"CAST", (Object)Boolean.FALSE).put((Object)"CONSTRAINT", (Object)Boolean.FALSE).put((Object)"CREATE", (Object)Boolean.FALSE).put((Object)"CROSS", (Object)Boolean.FALSE).put((Object)"CUBE", (Object)Boolean.TRUE).put((Object)"CURRENT_DATE", (Object)Boolean.FALSE).put((Object)"CURRENT_TIME", (Object)Boolean.FALSE).put((Object)"CURRENT_TIMESTAMP", (Object)Boolean.FALSE).put((Object)"CURRENT_USER", (Object)Boolean.TRUE).put((Object)"DEALLOCATE", (Object)Boolean.FALSE).put((Object)"DELETE", (Object)Boolean.FALSE).put((Object)"DESCRIBE", (Object)Boolean.FALSE).put((Object)"DISTINCT", (Object)Boolean.FALSE).put((Object)"DROP", (Object)Boolean.FALSE).put((Object)"ELSE", (Object)Boolean.FALSE).put((Object)"END", (Object)Boolean.FALSE).put((Object)"ESCAPE", (Object)Boolean.FALSE).put((Object)"EXCEPT", (Object)Boolean.FALSE).put((Object)"EXECUTE", (Object)Boolean.FALSE).put((Object)"EXISTS", (Object)Boolean.FALSE).put((Object)"EXTRACT", (Object)Boolean.FALSE).put((Object)"FALSE", (Object)Boolean.FALSE).put((Object)"FOR", (Object)Boolean.FALSE).put((Object)"FROM", (Object)Boolean.FALSE).put((Object)"FULL", (Object)Boolean.FALSE).put((Object)"GROUP", (Object)Boolean.FALSE).put((Object)"GROUPING", (Object)Boolean.TRUE).put((Object)"HAVING", (Object)Boolean.FALSE).put((Object)"IN", (Object)Boolean.FALSE).put((Object)"INNER", (Object)Boolean.FALSE).put((Object)"INSERT", (Object)Boolean.FALSE).put((Object)"INTERSECT", (Object)Boolean.FALSE).put((Object)"INTO", (Object)Boolean.FALSE).put((Object)"IS", (Object)Boolean.FALSE).put((Object)"JOIN", (Object)Boolean.FALSE).put((Object)"LEFT", (Object)Boolean.FALSE).put((Object)"LIKE", (Object)Boolean.FALSE).put((Object)"LOCALTIME", (Object)Boolean.TRUE).put((Object)"LOCALTIMESTAMP", (Object)Boolean.TRUE).put((Object)"NATURAL", (Object)Boolean.FALSE).put((Object)"NORMALIZE", (Object)Boolean.TRUE).put((Object)"NOT", (Object)Boolean.FALSE).put((Object)"NULL", (Object)Boolean.FALSE).put((Object)"ON", (Object)Boolean.FALSE).put((Object)"OR", (Object)Boolean.FALSE).put((Object)"ORDER", (Object)Boolean.FALSE).put((Object)"OUTER", (Object)Boolean.FALSE).put((Object)"PREPARE", (Object)Boolean.FALSE).put((Object)"RECURSIVE", (Object)Boolean.TRUE).put((Object)"RIGHT", (Object)Boolean.FALSE).put((Object)"ROLLUP", (Object)Boolean.TRUE).put((Object)"SELECT", (Object)Boolean.FALSE).put((Object)"TABLE", (Object)Boolean.FALSE).put((Object)"THEN", (Object)Boolean.FALSE).put((Object)"TRUE", (Object)Boolean.FALSE).put((Object)"UESCAPE", (Object)Boolean.TRUE).put((Object)"UNION", (Object)Boolean.FALSE).put((Object)"UNNEST", (Object)Boolean.TRUE).put((Object)"USING", (Object)Boolean.FALSE).put((Object)"VALUES", (Object)Boolean.FALSE).put((Object)"WHEN", (Object)Boolean.FALSE).put((Object)"WHERE", (Object)Boolean.FALSE).put((Object)"WITH", (Object)Boolean.FALSE).build();

    private TrinoKeywordsConverter() {
    }

    public static String quoteReservedKeyword(String value) {
        if (RESERVED_KEYWORDS.containsKey(value.toUpperCase())) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

