/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.functions;

import com.linkedin.coral.com.google.common.base.Preconditions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

abstract class GenericTemplateFunction
extends SqlUserDefinedFunction {
    private final RelDataType genericDataType;

    public GenericTemplateFunction(RelDataType genericDataType, String functionName) {
        super(new SqlIdentifier(functionName, SqlParserPos.ZERO), null, null, null, null, null);
        this.genericDataType = genericDataType;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        return this.genericDataType;
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.genericDataType;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return true;
    }

    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argTypeChecker, SqlCall call) {
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        Preconditions.checkState((call.operandCount() == 1 ? 1 : 0) != 0);
        String lambdaFunctionString = call.operand(0).toString();
        if (lambdaFunctionString.charAt(0) == '\'' && lambdaFunctionString.charAt(lambdaFunctionString.length() - 1) == '\'') {
            lambdaFunctionString = lambdaFunctionString.substring(1, lambdaFunctionString.length() - 1);
        }
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        writer.literal(lambdaFunctionString);
        writer.endFunCall(frame);
    }
}

