/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class TrinoSqlDialect
extends SqlDialect {
    private static final String IDENTIFIER_QUOTE_STRING = "\"";
    public static final TrinoSqlDialect INSTANCE = new TrinoSqlDialect(TrinoSqlDialect.emptyContext().withDatabaseProduct(SqlDialect.DatabaseProduct.UNKNOWN).withDatabaseProductName("Trino").withIdentifierQuoteString("\"").withNullCollation(NullCollation.LAST));

    private TrinoSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    public boolean supportsCharSet() {
        return false;
    }

    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getOperator().kind) {
            case MAP_VALUE_CONSTRUCTOR: {
                this.unparseMapValueConstructor(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    public String quoteIdentifier(String name) {
        if (name.contains(IDENTIFIER_QUOTE_STRING)) {
            return name;
        }
        return IDENTIFIER_QUOTE_STRING + name + IDENTIFIER_QUOTE_STRING;
    }

    public void unparseIdentifier(SqlWriter writer, SqlIdentifier identifier) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        for (int i = 0; i < identifier.names.size(); ++i) {
            writer.sep(".");
            String name = (String)identifier.names.get(i);
            SqlParserPos pos = identifier.getComponentParserPosition(i);
            if (name.equals("")) {
                writer.print("*");
                continue;
            }
            writer.identifier(name, pos.isQuoted());
        }
        writer.endList(frame);
    }

    public boolean requireCastOnString() {
        return true;
    }

    private void unparseMapValueConstructor(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(call.getOperator().getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (int i = 0; i < call.operandCount(); ++i) {
            writer.sep(",");
            call.operand(i).unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }
}

