/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.rel.HiveUncollect;
import com.linkedin.coral.trino.rel2trino.Calcite2TrinoUDFConverter;
import com.linkedin.coral.trino.rel2trino.TrinoSqlDialect;
import com.linkedin.coral.trino.rel2trino.TrinoSqlRewriter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoArrayTransformFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Util;

public class RelToTrinoConverter
extends RelToSqlConverter {
    public RelToTrinoConverter() {
        super((SqlDialect)TrinoSqlDialect.INSTANCE);
    }

    public String convert(RelNode relNode) {
        RelNode rel = Calcite2TrinoUDFConverter.convertRel(relNode);
        return ((SqlNode)this.convertToSqlNode(rel).accept((SqlVisitor)new TrinoSqlRewriter())).toSqlString((SqlDialect)TrinoSqlDialect.INSTANCE).toString();
    }

    public SqlNode convertToSqlNode(RelNode relNode) {
        return this.visitChild(0, relNode).asStatement();
    }

    public SqlImplementor.Result visit(Window window) {
        return null;
    }

    public SqlImplementor.Result visit(Project e) {
        e.getVariablesSet();
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable((RelNode)e, x);
        SqlImplementor.Builder builder = x.builder((RelNode)e, new SqlImplementor.Clause[]{SqlImplementor.Clause.SELECT});
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        boolean nestedFieldAccess;
        SqlNode selectNode = node;
        String name = (String)rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias((SqlNode)selectNode, (int)-1);
        String lowerName = name.toLowerCase(Locale.ROOT);
        boolean bl = nestedFieldAccess = selectNode instanceof SqlIdentifier && ((SqlIdentifier)selectNode).names.size() > 1;
        if (lowerName.startsWith("expr$")) {
            this.ordinalMap.put(lowerName, selectNode);
        } else if (alias == null || !alias.equals(name) || nestedFieldAccess) {
            selectNode = this.as(selectNode, name);
        }
        selectList.add(selectNode);
    }

    private SqlCall as(SqlNode e, String alias) {
        return SqlStdOperatorTable.AS.createCall(POS, new SqlNode[]{e, new SqlIdentifier(alias, POS)});
    }

    public SqlImplementor.Result visit(Uncollect e) {
        if (!this.isTrinoSupportedUnnest(e)) {
            throw new UnsupportedOperationException("Trino does not allow unnest a result of a queries");
        }
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        ArrayList<Object> unnestOperands = new ArrayList<Object>();
        for (RexNode unnestCol : ((Project)e.getInput()).getChildExps()) {
            if (e instanceof HiveUncollect && unnestCol.getType().getSqlTypeName().equals((Object)SqlTypeName.ARRAY) && unnestCol.getType().getComponentType().getSqlTypeName().equals((Object)SqlTypeName.ROW)) {
                RelRecordType transformDataType = new RelRecordType((List)ImmutableList.of((Object)new RelDataTypeFieldImpl("wrapper_field", 0, unnestCol.getType().getComponentType())));
                TrinoArrayTransformFunction tranformFunction = new TrinoArrayTransformFunction((RelDataType)transformDataType);
                SqlNode fieldRef = x.qualifiedContext().toSql(null, unnestCol);
                String fieldRefString = fieldRef.toSqlString((SqlDialect)TrinoSqlDialect.INSTANCE).getSql();
                SqlCharStringLiteral transformArgsLiteral = SqlLiteral.createCharString((String)String.format("%s, x -> ROW(x)", fieldRefString), (SqlParserPos)POS);
                unnestOperands.add(tranformFunction.createCall(POS, new SqlNode[]{transformArgsLiteral}));
                continue;
            }
            unnestOperands.add(x.qualifiedContext().toSql(null, unnestCol));
        }
        SqlCall unnestNode = SqlStdOperatorTable.UNNEST.createCall(POS, unnestOperands);
        List asOperands = this.createAsFullOperands(e.getRowType(), (SqlNode)unnestNode, x.neededAlias);
        SqlCall asNode = SqlStdOperatorTable.AS.createCall(POS, asOperands);
        return this.result((SqlNode)asNode, (Collection)ImmutableList.of((Object)SqlImplementor.Clause.FROM), (RelNode)e, null);
    }

    public SqlImplementor.Result visit(TableScan e) {
        List qualifiedName = e.getTable().getQualifiedName();
        if (qualifiedName.size() > 2) {
            qualifiedName = qualifiedName.subList(qualifiedName.size() - 2, qualifiedName.size());
        }
        SqlIdentifier identifier = new SqlIdentifier(qualifiedName, SqlParserPos.ZERO);
        return this.result((SqlNode)identifier, (Collection)ImmutableList.of((Object)SqlImplementor.Clause.FROM), (RelNode)e, null);
    }

    private boolean isTrinoSupportedUnnest(Uncollect uncollect) {
        if (!(uncollect.getInput() instanceof Project) || !(((Project)uncollect.getInput()).getInput() instanceof Values)) {
            return false;
        }
        Values values = (Values)((Project)uncollect.getInput()).getInput();
        if (values.getTuples().size() == 1 && ((ImmutableList)values.getTuples().get(0)).size() == 1) {
            RexLiteral val = (RexLiteral)((ImmutableList)values.getTuples().get(0)).get(0);
            return val.getValue().equals(new BigDecimal(0));
        }
        return false;
    }

    public SqlImplementor.Result visit(Correlate e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias(e.getCorrelVariable(), e.getLeft().getRowType());
        this.parseCorrelTable((RelNode)e, leftResult);
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight());
        SqlNode rightLateral = rightResult.node;
        rightLateral = SqlStdOperatorTable.LATERAL.createCall(POS, new SqlNode[]{rightLateral});
        if (rightLateral.getKind() != SqlKind.AS) {
            rightLateral = SqlStdOperatorTable.AS.createCall(POS, new SqlNode[]{rightLateral, new SqlIdentifier(rightResult.neededAlias, POS)});
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)POS), JoinType.CROSS.symbol(POS), rightLateral, JoinConditionType.NONE.symbol(POS), null);
        return this.result((SqlNode)join, leftResult, rightResult);
    }

    public SqlImplementor.Context aliasContext(final Map<String, RelDataType> aliases, final boolean qualified) {
        return new SqlImplementor.AliasContext(TrinoSqlDialect.INSTANCE, aliases, qualified){

            public SqlNode field(int ordinal) {
                for (Map.Entry alias : aliases.entrySet()) {
                    List fields = ((RelDataType)alias.getValue()).getFieldList();
                    if (ordinal < fields.size()) {
                        RelDataTypeField field = (RelDataTypeField)fields.get(ordinal);
                        SqlNode mappedSqlNode = (SqlNode)RelToTrinoConverter.this.ordinalMap.get(field.getName().toLowerCase(Locale.ROOT));
                        if (mappedSqlNode != null) {
                            return this.ensureAliasedNode((String)alias.getKey(), mappedSqlNode);
                        }
                        return new SqlIdentifier((List)(!qualified ? ImmutableList.of((Object)field.getName()) : ImmutableList.of(alias.getKey(), (Object)field.getName())), SqlImplementor.POS);
                    }
                    ordinal -= fields.size();
                }
                throw new AssertionError((Object)("field ordinal " + ordinal + " out of range " + aliases));
            }

            protected SqlNode ensureAliasedNode(String alias, SqlNode id) {
                if (!(id instanceof SqlIdentifier)) {
                    return id;
                }
                ImmutableList names = ((SqlIdentifier)id).names;
                if (names.size() > 1) {
                    return id;
                }
                return new SqlIdentifier((List)ImmutableList.of((Object)alias, (Object)Util.last((List)names)), SqlImplementor.POS);
            }

            private RexNode stripCastFromString(RexNode node) {
                return node;
            }
        };
    }
}

