/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.linkedin.coral.com.google.common.base.CaseFormat;
import com.linkedin.coral.com.google.common.base.Converter;
import com.linkedin.coral.com.google.common.collect.ImmutableMultimap;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.trino.rel2trino.UDFMapUtils;
import com.linkedin.coral.trino.rel2trino.UDFTransformer;
import com.linkedin.coral.trino.rel2trino.functions.TrinoElementAtFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class CalciteTrinoUDFMap {
    private static final Map<String, UDFTransformer> UDF_MAP = new HashMap<String, UDFTransformer>();
    private static final StaticHiveFunctionRegistry HIVE_REGISTRY = new StaticHiveFunctionRegistry();

    private CalciteTrinoUDFMap() {
    }

    private static void addDaliUDFs() {
        ImmutableMultimap registry = HIVE_REGISTRY.getRegistry();
        Converter caseConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
        for (Map.Entry entry : registry.entries()) {
            String hiveFunctionName = ((HiveFunction)entry.getValue()).getHiveFunctionName();
            if (!hiveFunctionName.startsWith("com.linkedin")) continue;
            String[] nameSplit = hiveFunctionName.split("\\.");
            String className = nameSplit[nameSplit.length - 1];
            String funcName = (String)caseConverter.convert((Object)className);
            SqlOperator op = ((HiveFunction)entry.getValue()).getSqlOperator();
            for (int i = op.getOperandCountRange().getMin(); i <= op.getOperandCountRange().getMax(); ++i) {
                if (CalciteTrinoUDFMap.isDaliUDFAlreadyAdded(hiveFunctionName, i).booleanValue()) continue;
                UDFMapUtils.createUDFMapEntry(UDF_MAP, op, i, funcName);
            }
        }
    }

    public static UDFTransformer getUDFTransformer(String calciteOpName, int numOperands) {
        return UDF_MAP.get(UDFMapUtils.getKey(calciteOpName, numOperands));
    }

    private static Boolean isDaliUDFAlreadyAdded(String classString, int numOperands) {
        return CalciteTrinoUDFMap.getUDFTransformer(classString, numOperands) != null;
    }

    private static SqlOperator hiveToCalciteOp(String functionName) {
        Collection lookup = HIVE_REGISTRY.lookup(functionName);
        return ((HiveFunction)lookup.iterator().next()).getSqlOperator();
    }

    private static SqlOperator daliToCalciteOp(String className) {
        return ((HiveFunction)HIVE_REGISTRY.lookup(className).iterator().next()).getSqlOperator();
    }

    static {
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("nvl"), 2, "coalesce");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, SqlStdOperatorTable.ITEM, 2, (SqlOperator)TrinoElementAtFunction.INSTANCE);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.RAND, 0, "RANDOM");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.RAND, 1, "RANDOM", "[]", null);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.RAND_INTEGER, 1, "RANDOM");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.RAND_INTEGER, 2, "RANDOM", "[{\"input\":2}]", null);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.TRUNCATE, 2, "TRUNCATE", "[{\"op\":\"*\",\"operands\":[{\"input\":1},{\"op\":\"^\",\"operands\":[{\"value\":10},{\"input\":2}]}]}]", "{\"op\":\"/\",\"operands\":[{\"input\":0},{\"op\":\"^\",\"operands\":[{\"value\":10},{\"input\":2}]}]}");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.SUBSTRING, 2, "SUBSTR");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)SqlStdOperatorTable.SUBSTRING, 3, "SUBSTR");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)HiveRLikeOperator.RLIKE, 2, "REGEXP_LIKE");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, (SqlOperator)HiveRLikeOperator.REGEXP, 2, "REGEXP_LIKE");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("get_json_object"), 2, "json_extract");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("pmod"), 2, "mod", "[{\"op\":\"+\",\"operands\":[{\"op\":\"%\",\"operands\":[{\"input\":1},{\"input\":2}]},{\"input\":2}]},{\"input\":2}]", null);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("base64"), 1, "to_base64");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("unbase64"), 1, "from_base64");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("hex"), 1, "to_hex");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("unhex"), 1, "from_hex");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("array_contains"), 2, "contains");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("regexp_extract"), 3, "regexp_extract", "[{\"input\": 1}, {\"op\": \"hive_pattern_to_trino\", \"operands\":[{\"input\": 2}]}, {\"input\": 3}]", null);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("instr"), 2, "strpos");
        UDFMapUtils.createRuntimeUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.hiveToCalciteOp("decode"), 2, "[{\"regex\":\"(?i)('utf-8')\", \"input\":2, \"name\":\"from_utf8\"}]", "[{\"input\":1}]", null);
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.daliToCalciteOp("com.linkedin.dali.udf.watbotcrawlerlookup.hive.WATBotCrawlerLookup"), 3, "wat_bot_crawler_lookup");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.daliToCalciteOp("com.linkedin.stdudfs.parsing.hive.Ip2Str"), 1, "ip2str");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.daliToCalciteOp("com.linkedin.stdudfs.parsing.hive.Ip2Str"), 3, "ip2str");
        UDFMapUtils.createUDFMapEntry(UDF_MAP, CalciteTrinoUDFMap.daliToCalciteOp("com.linkedin.stdudfs.parsing.hive.UserAgentParser"), 2, "useragentparser");
        CalciteTrinoUDFMap.addDaliUDFs();
    }
}

