/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcBlockFactory;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.reader.BooleanColumnReader;
import io.trino.orc.reader.ByteColumnReader;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.DecimalColumnReader;
import io.trino.orc.reader.DoubleColumnReader;
import io.trino.orc.reader.FloatColumnReader;
import io.trino.orc.reader.ListColumnReader;
import io.trino.orc.reader.LongColumnReader;
import io.trino.orc.reader.MapColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.reader.SliceColumnReader;
import io.trino.orc.reader.StructColumnReader;
import io.trino.orc.reader.TimeColumnReader;
import io.trino.orc.reader.TimestampColumnReader;
import io.trino.orc.reader.UnionColumnReader;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;

public final class ColumnReaders {
    private ColumnReaders() {
    }

    public static ColumnReader createColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout projectedLayout, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        if (type instanceof TimeType) {
            if (!type.equals(TimeType.TIME_MICROS) || column.getColumnType() != OrcType.OrcTypeKind.LONG || !"TIME".equals(column.getAttributes().get("iceberg.long-type"))) {
                throw ReaderUtils.invalidStreamType(column, type);
            }
            return new TimeColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
        }
        switch (column.getColumnType()) {
            case BOOLEAN: {
                return new BooleanColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceColumnReader(type, column, systemMemoryContext);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListColumnReader(type, column, systemMemoryContext, blockFactory, fieldMapperFactory);
            }
            case STRUCT: {
                return new StructColumnReader(type, column, projectedLayout, systemMemoryContext, blockFactory, fieldMapperFactory);
            }
            case MAP: {
                return new MapColumnReader(type, column, systemMemoryContext, blockFactory, fieldMapperFactory);
            }
            case DECIMAL: {
                return new DecimalColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case UNION: {
                return new UnionColumnReader(type, column, systemMemoryContext, blockFactory, fieldMapperFactory);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + column.getColumnType());
    }
}

