/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.com.google.common.base.Preconditions;
import com.linkedin.coral.javax.annotation.Nonnull;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Util;

public class DateString
implements Comparable<DateString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    final String v;

    private DateString(String v, boolean ignore) {
        this.v = v;
    }

    public DateString(String v) {
        this(v, false);
        Preconditions.checkArgument(PATTERN.matcher(v).matches(), "Invalid date format:", v);
        Preconditions.checkArgument(this.getYear() >= 1 && this.getYear() <= 9999, "Year out of range:", this.getYear());
        Preconditions.checkArgument(this.getMonth() >= 1 && this.getMonth() <= 12, "Month out of range:", this.getMonth());
        Preconditions.checkArgument(this.getDay() >= 1 && this.getDay() <= 31, "Day out of range:", this.getDay());
    }

    public DateString(int year, int month, int day) {
        this(DateString.ymd(year, month, day), true);
    }

    private static String ymd(int year, int month, int day) {
        Preconditions.checkArgument(year >= 1 && year <= 9999, "Year out of range:", year);
        Preconditions.checkArgument(month >= 1 && month <= 12, "Month out of range:", month);
        Preconditions.checkArgument(day >= 1 && day <= 31, "Day out of range:", day);
        StringBuilder b = new StringBuilder();
        DateTimeStringUtils.ymd(b, year, month, day);
        return b.toString();
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DateString && ((DateString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(@Nonnull DateString o) {
        return this.v.compareTo(o.v);
    }

    public static DateString fromCalendarFields(Calendar calendar) {
        return new DateString(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public int getDaysSinceEpoch() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        return DateTimeUtils.ymdToUnixDate(year, month, day);
    }

    private int getYear() {
        return Integer.parseInt(this.v.substring(0, 4));
    }

    private int getMonth() {
        return Integer.parseInt(this.v.substring(5, 7));
    }

    private int getDay() {
        return Integer.parseInt(this.v.substring(8, 10));
    }

    public static DateString fromDaysSinceEpoch(int days) {
        return new DateString(DateTimeUtils.unixDateToString(days));
    }

    public long getMillisSinceEpoch() {
        return (long)this.getDaysSinceEpoch() * 86400000L;
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisSinceEpoch());
    }
}

