/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.util.Static;

public class MultisetOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode op0 = callBinding.operand(0);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
            return false;
        }
        SqlNode op1 = callBinding.operand(1);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, op1, 0, throwOnFailure)) {
            return false;
        }
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(ImmutableList.of(callBinding.getValidator().deriveType(callBinding.getScope(), op0).getComponentType(), callBinding.getValidator().deriveType(callBinding.getScope(), op1).getComponentType()));
        if (null == biggest) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(op0.getParserPosition().toString(), op1.getParserPosition().toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<MULTISET> " + opName + " <MULTISET>";
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

