/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.com.esri.core.geometry.NumberUtils;
import java.util.Arrays;
import java.util.Comparator;

public class SimpleRasterizer {
    public static final int EVEN_ODD = 0;
    public static final int WINDING = 1;
    private static final EdgeComparator edgeCompare_ = new EdgeComparator();
    private Edge activeEdgesTable_;
    private Edge[] ySortedEdges_;
    private Edge[] sortBuffer_;
    private int[] scanBuffer_;
    int scanPtr_;
    private ScanCallback callback_;
    private int width_ = -1;
    private int height_ = -1;
    private int minY_;
    private int maxY_;
    private int numEdges_;
    private int sortedNum_;
    private boolean evenOdd_;

    public void setup(int width, int height, ScanCallback callback) {
        this.width_ = width;
        this.height_ = height;
        this.ySortedEdges_ = null;
        this.activeEdgesTable_ = null;
        this.numEdges_ = 0;
        this.callback_ = callback;
        if (this.scanBuffer_ == null) {
            this.scanBuffer_ = new int[384];
        }
        this.startAddingEdges();
    }

    public final int getWidth() {
        return this.width_;
    }

    public final int getHeight() {
        return this.height_;
    }

    public final void flush() {
        if (this.scanPtr_ > 0) {
            this.callback_.drawScan(this.scanBuffer_, this.scanPtr_);
            this.scanPtr_ = 0;
        }
    }

    public final void addTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.addEdge(x1, y1, x2, y2);
        this.addEdge(x2, y2, x3, y3);
        this.addEdge(x1, y1, x3, y3);
    }

    public final void addRing(double[] xy) {
        for (int i = 2; i < xy.length; i += 2) {
            this.addEdge(xy[i - 2], xy[i - 1], xy[i], xy[i + 1]);
        }
    }

    public final void startAddingEdges() {
        if (this.numEdges_ > 0) {
            for (int i = 0; i < this.height_; ++i) {
                Edge e = this.ySortedEdges_[i];
                while (e != null) {
                    Edge p = e;
                    e = e.next;
                    p.next = null;
                }
                this.ySortedEdges_[i] = null;
            }
            this.activeEdgesTable_ = null;
        }
        this.minY_ = this.height_;
        this.maxY_ = -1;
        this.numEdges_ = 0;
    }

    public final void renderEdges(int fillMode) {
        this.evenOdd_ = fillMode == 0;
        for (int line = this.minY_; line <= this.maxY_; ++line) {
            this.advanceAET_();
            this.addNewEdgesToAET_(line);
            this.emitScans_();
        }
        this.startAddingEdges();
    }

    public final void addEdge(double x1, double y1, double x2, double y2) {
        if (y1 == y2) {
            return;
        }
        int dir = 1;
        if (y1 > y2) {
            double temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
            dir = -1;
        }
        if (y2 < 0.0 || y1 >= (double)this.height_) {
            return;
        }
        if (x1 < 0.0 && x2 < 0.0) {
            x1 = -1.0;
            x2 = -1.0;
        } else if (x1 >= (double)this.width_ && x2 >= (double)this.width_) {
            x1 = this.width_;
            x2 = this.width_;
        }
        double dxdy = (x2 - x1) / (y2 - y1);
        if (y2 > (double)this.height_) {
            y2 = this.height_;
            x2 = dxdy * (y2 - y1) + x1;
        }
        if (y1 < 0.0) {
            x1 = dxdy * (0.0 - y1) + x1;
            y1 = 0.0;
        }
        int bigX = Math.max(this.width_ + 1, 0x7FFFFF);
        if (x1 < -8388607.0) {
            y1 = (0.0 - x1) / dxdy + y1;
            x1 = 0.0;
        } else if (x1 > (double)bigX) {
            y1 = ((double)this.width_ - x1) / dxdy + y1;
            x1 = this.width_;
        }
        if (x2 < -8388607.0) {
            y2 = (0.0 - x1) / dxdy + y1;
            x2 = 0.0;
        } else if (x2 > (double)bigX) {
            y2 = ((double)this.width_ - x1) / dxdy + y1;
            x2 = this.width_;
        }
        int ystart = (int)y1;
        int yend = (int)y2;
        if (ystart == yend) {
            return;
        }
        Edge e = new Edge();
        e.x = (long)(x1 * 4.294967296E9);
        e.y = ystart;
        e.ymax = yend;
        e.dxdy = (long)(dxdy * 4.294967296E9);
        e.dir = dir;
        if (this.ySortedEdges_ == null) {
            this.ySortedEdges_ = new Edge[this.height_];
        }
        e.next = this.ySortedEdges_[e.y];
        this.ySortedEdges_[e.y] = e;
        if (e.y < this.minY_) {
            this.minY_ = e.y;
        }
        if (e.ymax > this.maxY_) {
            this.maxY_ = e.ymax;
        }
        ++this.numEdges_;
    }

    public final void fillEnvelope(Envelope2D envIn) {
        Envelope2D env = new Envelope2D(0.0, 0.0, this.width_, this.height_);
        if (!env.intersect(envIn)) {
            return;
        }
        int x0 = (int)env.xmin;
        int x = (int)env.xmax;
        int xn = NumberUtils.snap(x0, 0, this.width_);
        int xm = NumberUtils.snap(x, 0, this.width_);
        if (x0 < this.width_ && xn < xm) {
            int y0 = (int)env.ymin;
            int y1 = (int)env.ymax;
            y0 = NumberUtils.snap(y0, 0, this.height_);
            y1 = NumberUtils.snap(y1, 0, this.height_);
            if (y0 < this.height_) {
                for (int y = y0; y < y1; ++y) {
                    this.scanBuffer_[this.scanPtr_++] = xn;
                    this.scanBuffer_[this.scanPtr_++] = xm;
                    this.scanBuffer_[this.scanPtr_++] = y;
                    if (this.scanPtr_ != this.scanBuffer_.length) continue;
                    this.callback_.drawScan(this.scanBuffer_, this.scanPtr_);
                    this.scanPtr_ = 0;
                }
            }
        }
    }

    final boolean addSegmentStroke(double x1, double y1, double x2, double y2, double half_width, boolean skip_short, double[] helper_xy_10_elm) {
        boolean bshort;
        double vec_x = x2 - x1;
        double vec_y = y2 - y1;
        double len = Math.sqrt(vec_x * vec_x + vec_y * vec_y);
        if (skip_short && len < 0.5) {
            return false;
        }
        boolean bl = bshort = len < 1.0E-5;
        if (bshort) {
            vec_x = len = 1.0E-5;
            vec_y = 0.0;
        }
        double f = half_width / len;
        double vecA_x = -(vec_y *= f);
        double vecA_y = vec_x *= f;
        double vecB_x = vec_y;
        double vecB_y = -vec_x;
        x1 -= vec_x;
        y1 -= vec_y;
        x2 += vec_x;
        y2 += vec_y;
        double[] fan = helper_xy_10_elm;
        assert (fan.length == 10);
        fan[0] = x1 + vecA_x;
        fan[1] = y1 + vecA_y;
        fan[2] = x1 + vecB_x;
        fan[3] = y1 + vecB_y;
        fan[4] = x2 + vecB_x;
        fan[5] = y2 + vecB_y;
        fan[6] = x2 + vecA_x;
        fan[7] = y2 + vecA_y;
        fan[8] = fan[0];
        fan[9] = fan[1];
        this.addRing(fan);
        return true;
    }

    public final ScanCallback getScanCallback() {
        return this.callback_;
    }

    private final void advanceAET_() {
        if (this.activeEdgesTable_ == null) {
            return;
        }
        boolean needSort = false;
        Edge prev = null;
        Edge e = this.activeEdgesTable_;
        while (e != null) {
            ++e.y;
            if (e.y == e.ymax) {
                Edge p = e;
                e = e.next;
                if (prev != null) {
                    prev.next = e;
                } else {
                    this.activeEdgesTable_ = e;
                }
                p.next = null;
                continue;
            }
            e.x += e.dxdy;
            if (prev != null && prev.x > e.x) {
                needSort = true;
            }
            prev = e;
            e = e.next;
        }
        if (needSort) {
            this.activeEdgesTable_ = this.sortAET_(this.activeEdgesTable_);
        }
    }

    private final void addNewEdgesToAET_(int y) {
        if (y >= this.height_) {
            return;
        }
        Edge edgesOnLine = this.ySortedEdges_[y];
        if (edgesOnLine != null) {
            this.ySortedEdges_[y] = null;
            edgesOnLine = this.sortAET_(edgesOnLine);
            this.numEdges_ -= this.sortedNum_;
            Edge aet = this.activeEdgesTable_;
            boolean first = true;
            Edge newEdge = edgesOnLine;
            Edge prev_aet = null;
            while (aet != null && newEdge != null) {
                Edge p;
                if (aet.x > newEdge.x) {
                    if (first) {
                        this.activeEdgesTable_ = newEdge;
                    }
                    p = newEdge.next;
                    newEdge.next = aet;
                    if (prev_aet != null) {
                        prev_aet.next = newEdge;
                    }
                    prev_aet = newEdge;
                    newEdge = p;
                } else {
                    p = aet.next;
                    aet.next = newEdge;
                    if (prev_aet != null) {
                        prev_aet.next = aet;
                    }
                    prev_aet = aet;
                    aet = p;
                }
                first = false;
            }
            if (this.activeEdgesTable_ == null) {
                this.activeEdgesTable_ = edgesOnLine;
            }
        }
    }

    private static int snap_(int x, int mi, int ma) {
        return x < mi ? mi : (x > ma ? ma : x);
    }

    private final void emitScans_() {
        if (this.activeEdgesTable_ == null) {
            return;
        }
        int w = 0;
        Edge e0 = this.activeEdgesTable_;
        int x0 = (int)(e0.x >> 32);
        Edge e = e0.next;
        while (e != null) {
            w = this.evenOdd_ ? (w ^= 1) : (w += e.dir);
            if (e.x > e0.x) {
                int x = (int)(e.x >> 32);
                if (w != 0) {
                    int xx0 = SimpleRasterizer.snap_(x0, 0, this.width_);
                    int xx = SimpleRasterizer.snap_(x, 0, this.width_);
                    if (xx > xx0 && xx0 < this.width_) {
                        this.scanBuffer_[this.scanPtr_++] = xx0;
                        this.scanBuffer_[this.scanPtr_++] = xx;
                        this.scanBuffer_[this.scanPtr_++] = e.y;
                        if (this.scanPtr_ == this.scanBuffer_.length) {
                            this.callback_.drawScan(this.scanBuffer_, this.scanPtr_);
                            this.scanPtr_ = 0;
                        }
                    }
                }
                e0 = e;
                x0 = x;
            }
            e = e.next;
        }
    }

    private final Edge sortAET_(Edge aet) {
        int num = 0;
        Edge e = aet;
        while (e != null) {
            ++num;
            e = e.next;
        }
        this.sortedNum_ = num;
        if (num == 1) {
            return aet;
        }
        if (this.sortBuffer_ == null) {
            this.sortBuffer_ = new Edge[Math.max(num, 16)];
        } else if (this.sortBuffer_.length < num) {
            this.sortBuffer_ = new Edge[Math.max(num, this.sortBuffer_.length * 2)];
        }
        int i = 0;
        Edge e2 = aet;
        while (e2 != null) {
            this.sortBuffer_[i++] = e2;
            e2 = e2.next;
        }
        if (num == 2) {
            if (this.sortBuffer_[0].x > this.sortBuffer_[1].x) {
                Edge tmp = this.sortBuffer_[0];
                this.sortBuffer_[0] = this.sortBuffer_[1];
                this.sortBuffer_[1] = tmp;
            }
        } else {
            Arrays.sort(this.sortBuffer_, 0, num, edgeCompare_);
        }
        aet = this.sortBuffer_[0];
        this.sortBuffer_[0] = null;
        Edge prev = aet;
        for (int i2 = 1; i2 < num; ++i2) {
            prev.next = this.sortBuffer_[i2];
            prev = this.sortBuffer_[i2];
            this.sortBuffer_[i2] = null;
        }
        prev.next = null;
        return aet;
    }

    private static class EdgeComparator
    implements Comparator<Edge> {
        private EdgeComparator() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.x < o2.x ? -1 : (o1.x > o2.x ? 1 : 0);
        }
    }

    private static class Edge {
        long x;
        long dxdy;
        int y;
        int ymax;
        int dir;
        Edge next;

        private Edge() {
        }
    }

    public static interface ScanCallback {
        public void drawScan(int[] var1, int var2);
    }
}

