/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.GeometryCursor;
import com.linkedin.coral.com.esri.core.geometry.JsonParserReader;
import com.linkedin.coral.com.esri.core.geometry.JsonReader;
import com.linkedin.coral.com.esri.core.geometry.MapGeometry;
import com.linkedin.coral.com.esri.core.geometry.Operator;
import com.linkedin.coral.com.esri.core.geometry.OperatorBuffer;
import com.linkedin.coral.com.esri.core.geometry.OperatorClip;
import com.linkedin.coral.com.esri.core.geometry.OperatorContains;
import com.linkedin.coral.com.esri.core.geometry.OperatorConvexHull;
import com.linkedin.coral.com.esri.core.geometry.OperatorCrosses;
import com.linkedin.coral.com.esri.core.geometry.OperatorCut;
import com.linkedin.coral.com.esri.core.geometry.OperatorDifference;
import com.linkedin.coral.com.esri.core.geometry.OperatorDisjoint;
import com.linkedin.coral.com.esri.core.geometry.OperatorDistance;
import com.linkedin.coral.com.esri.core.geometry.OperatorEquals;
import com.linkedin.coral.com.esri.core.geometry.OperatorExportToESRIShape;
import com.linkedin.coral.com.esri.core.geometry.OperatorExportToGeoJson;
import com.linkedin.coral.com.esri.core.geometry.OperatorExportToJson;
import com.linkedin.coral.com.esri.core.geometry.OperatorExportToWkt;
import com.linkedin.coral.com.esri.core.geometry.OperatorFactoryLocal;
import com.linkedin.coral.com.esri.core.geometry.OperatorImportFromESRIShape;
import com.linkedin.coral.com.esri.core.geometry.OperatorImportFromGeoJson;
import com.linkedin.coral.com.esri.core.geometry.OperatorImportFromJson;
import com.linkedin.coral.com.esri.core.geometry.OperatorImportFromWkt;
import com.linkedin.coral.com.esri.core.geometry.OperatorIntersection;
import com.linkedin.coral.com.esri.core.geometry.OperatorOverlaps;
import com.linkedin.coral.com.esri.core.geometry.OperatorProximity2D;
import com.linkedin.coral.com.esri.core.geometry.OperatorRelate;
import com.linkedin.coral.com.esri.core.geometry.OperatorSimplify;
import com.linkedin.coral.com.esri.core.geometry.OperatorSymmetricDifference;
import com.linkedin.coral.com.esri.core.geometry.OperatorTouches;
import com.linkedin.coral.com.esri.core.geometry.OperatorUnion;
import com.linkedin.coral.com.esri.core.geometry.OperatorWithin;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Polygon;
import com.linkedin.coral.com.esri.core.geometry.Polyline;
import com.linkedin.coral.com.esri.core.geometry.Proximity2DResult;
import com.linkedin.coral.com.esri.core.geometry.SimpleGeometryCursor;
import com.linkedin.coral.com.esri.core.geometry.SpatialReference;
import com.linkedin.coral.com.esri.core.geometry.SpatialReferenceImpl;
import com.linkedin.coral.com.fasterxml.jackson.core.JsonParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class GeometryEngine {
    private static OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();

    public static MapGeometry jsonToGeometry(JsonParser json) {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, new JsonParserReader(json));
        return geom;
    }

    public static MapGeometry jsonToGeometry(JsonReader json) {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        return geom;
    }

    public static MapGeometry jsonToGeometry(String json) {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        return geom;
    }

    public static String geometryToJson(int wkid, Geometry geometry) {
        return GeometryEngine.geometryToJson(wkid > 0 ? SpatialReference.create(wkid) : null, geometry);
    }

    public static String geometryToJson(SpatialReference spatialReference, Geometry geometry) {
        OperatorExportToJson exporter = (OperatorExportToJson)factory.getOperator(Operator.Type.ExportToJson);
        return exporter.execute(spatialReference, geometry);
    }

    public static String geometryToGeoJson(Geometry geometry) {
        OperatorExportToGeoJson exporter = (OperatorExportToGeoJson)factory.getOperator(Operator.Type.ExportToGeoJson);
        return exporter.execute(geometry);
    }

    public static MapGeometry geoJsonToGeometry(String json, int importFlags, Geometry.Type type) {
        MapGeometry geom = OperatorImportFromGeoJson.local().execute(importFlags, type, json, null);
        return geom;
    }

    public static String geometryToGeoJson(int wkid, Geometry geometry) {
        return GeometryEngine.geometryToGeoJson(wkid > 0 ? SpatialReference.create(wkid) : null, geometry);
    }

    public static String geometryToGeoJson(SpatialReference spatialReference, Geometry geometry) {
        OperatorExportToGeoJson exporter = (OperatorExportToGeoJson)factory.getOperator(Operator.Type.ExportToGeoJson);
        return exporter.execute(spatialReference, geometry);
    }

    public static Geometry geometryFromEsriShape(byte[] esriShapeBuffer, Geometry.Type geometryType) {
        OperatorImportFromESRIShape op = (OperatorImportFromESRIShape)factory.getOperator(Operator.Type.ImportFromESRIShape);
        return op.execute(2, geometryType, ByteBuffer.wrap(esriShapeBuffer).order(ByteOrder.LITTLE_ENDIAN));
    }

    public static byte[] geometryToEsriShape(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException();
        }
        OperatorExportToESRIShape op = (OperatorExportToESRIShape)factory.getOperator(Operator.Type.ExportToESRIShape);
        return op.execute(0, geometry).array();
    }

    public static Geometry geometryFromWkt(String wkt, int importFlags, Geometry.Type geometryType) {
        OperatorImportFromWkt op = (OperatorImportFromWkt)factory.getOperator(Operator.Type.ImportFromWkt);
        return op.execute(importFlags, geometryType, wkt, null);
    }

    public static String geometryToWkt(Geometry geometry, int exportFlags) {
        OperatorExportToWkt op = (OperatorExportToWkt)factory.getOperator(Operator.Type.ExportToWkt);
        return op.execute(exportFlags, geometry, null);
    }

    public static Geometry union(Geometry[] geometries, SpatialReference spatialReference) {
        OperatorUnion op = (OperatorUnion)factory.getOperator(Operator.Type.Union);
        SimpleGeometryCursor inputGeometries = new SimpleGeometryCursor(geometries);
        GeometryCursor result = op.execute(inputGeometries, spatialReference, null);
        return result.next();
    }

    public static Geometry difference(Geometry geometry1, Geometry substractor, SpatialReference spatialReference) {
        OperatorDifference op = (OperatorDifference)factory.getOperator(Operator.Type.Difference);
        Geometry result = op.execute(geometry1, substractor, spatialReference, null);
        return result;
    }

    public static Geometry symmetricDifference(Geometry leftGeometry, Geometry rightGeometry, SpatialReference spatialReference) {
        OperatorSymmetricDifference op = (OperatorSymmetricDifference)factory.getOperator(Operator.Type.SymmetricDifference);
        Geometry result = op.execute(leftGeometry, rightGeometry, spatialReference, null);
        return result;
    }

    public static boolean equals(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorEquals op = (OperatorEquals)factory.getOperator(Operator.Type.Equals);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean disjoint(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorDisjoint op = (OperatorDisjoint)factory.getOperator(Operator.Type.Disjoint);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    static Geometry[] intersect(Geometry[] inputGeometries, Geometry geometry, SpatialReference spatialReference) {
        Geometry g;
        OperatorIntersection op = (OperatorIntersection)factory.getOperator(Operator.Type.Intersection);
        SimpleGeometryCursor inputGeometriesCursor = new SimpleGeometryCursor(inputGeometries);
        SimpleGeometryCursor intersectorCursor = new SimpleGeometryCursor(geometry);
        GeometryCursor result = op.execute(inputGeometriesCursor, intersectorCursor, spatialReference, null);
        ArrayList<Geometry> resultGeoms = new ArrayList<Geometry>();
        while ((g = result.next()) != null) {
            resultGeoms.add(g);
        }
        Geometry[] resultarr = resultGeoms.toArray(new Geometry[0]);
        return resultarr;
    }

    public static Geometry intersect(Geometry geometry1, Geometry intersector, SpatialReference spatialReference) {
        OperatorIntersection op = (OperatorIntersection)factory.getOperator(Operator.Type.Intersection);
        Geometry result = op.execute(geometry1, intersector, spatialReference, null);
        return result;
    }

    public static boolean within(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorWithin op = (OperatorWithin)factory.getOperator(Operator.Type.Within);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean contains(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorContains op = (OperatorContains)factory.getOperator(Operator.Type.Contains);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean crosses(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorCrosses op = (OperatorCrosses)factory.getOperator(Operator.Type.Crosses);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean touches(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorTouches op = (OperatorTouches)factory.getOperator(Operator.Type.Touches);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean overlaps(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorOverlaps op = (OperatorOverlaps)factory.getOperator(Operator.Type.Overlaps);
        boolean result = op.execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    public static boolean relate(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference, String relation) {
        OperatorRelate op = (OperatorRelate)factory.getOperator(Operator.Type.Relate);
        boolean result = op.execute(geometry1, geometry2, spatialReference, relation, null);
        return result;
    }

    public static double distance(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        OperatorDistance op = (OperatorDistance)factory.getOperator(Operator.Type.Distance);
        double result = op.execute(geometry1, geometry2, null);
        return result;
    }

    public static Geometry clip(Geometry geometry, Envelope envelope, SpatialReference spatialReference) {
        OperatorClip op = (OperatorClip)factory.getOperator(Operator.Type.Clip);
        Geometry result = op.execute(geometry, Envelope2D.construct(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax()), spatialReference, null);
        return result;
    }

    public static Geometry[] cut(Geometry cuttee, Polyline cutter, SpatialReference spatialReference) {
        Geometry geometry;
        if (cuttee == null || cutter == null) {
            return null;
        }
        OperatorCut op = (OperatorCut)factory.getOperator(Operator.Type.Cut);
        GeometryCursor cursor = op.execute(true, cuttee, cutter, spatialReference, null);
        ArrayList<Geometry> cutsList = new ArrayList<Geometry>();
        while ((geometry = cursor.next()) != null) {
            if (geometry.isEmpty()) continue;
            cutsList.add(geometry);
        }
        return cutsList.toArray(new Geometry[0]);
    }

    public static Polygon[] buffer(Geometry[] geometries, SpatialReference spatialReference, double[] distances, boolean toUnionResults) {
        double[] bufferDistances = distances;
        OperatorBuffer op = (OperatorBuffer)factory.getOperator(Operator.Type.Buffer);
        if (toUnionResults) {
            Geometry g;
            SimpleGeometryCursor inputGeometriesCursor = new SimpleGeometryCursor(geometries);
            GeometryCursor result = op.execute(inputGeometriesCursor, spatialReference, bufferDistances, toUnionResults, null);
            ArrayList<Polygon> resultGeoms = new ArrayList<Polygon>();
            while ((g = result.next()) != null) {
                resultGeoms.add((Polygon)g);
            }
            Polygon[] buffers = resultGeoms.toArray(new Polygon[0]);
            return buffers;
        }
        Polygon[] buffers = new Polygon[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            buffers[i] = (Polygon)op.execute(geometries[i], spatialReference, bufferDistances[i], null);
        }
        return buffers;
    }

    public static Polygon buffer(Geometry geometry, SpatialReference spatialReference, double distance) {
        double bufferDistance = distance;
        OperatorBuffer op = (OperatorBuffer)factory.getOperator(Operator.Type.Buffer);
        Geometry result = op.execute(geometry, spatialReference, bufferDistance, null);
        return (Polygon)result;
    }

    public static Geometry convexHull(Geometry geometry) {
        OperatorConvexHull op = (OperatorConvexHull)factory.getOperator(Operator.Type.ConvexHull);
        return op.execute(geometry, null);
    }

    public static Geometry[] convexHull(Geometry[] geometries, boolean b_merge) {
        Geometry g;
        OperatorConvexHull op = (OperatorConvexHull)factory.getOperator(Operator.Type.ConvexHull);
        SimpleGeometryCursor simple_cursor = new SimpleGeometryCursor(geometries);
        GeometryCursor cursor = op.execute(simple_cursor, b_merge, null);
        ArrayList<Geometry> resultGeoms = new ArrayList<Geometry>();
        while ((g = cursor.next()) != null) {
            resultGeoms.add(g);
        }
        Geometry[] output = new Geometry[resultGeoms.size()];
        for (int i = 0; i < resultGeoms.size(); ++i) {
            output[i] = (Geometry)resultGeoms.get(i);
        }
        return output;
    }

    public static Proximity2DResult getNearestCoordinate(Geometry geometry, Point inputPoint, boolean bTestPolygonInterior) {
        OperatorProximity2D proximity = (OperatorProximity2D)factory.getOperator(Operator.Type.Proximity2D);
        Proximity2DResult result = proximity.getNearestCoordinate(geometry, inputPoint, bTestPolygonInterior);
        return result;
    }

    public static Proximity2DResult getNearestVertex(Geometry geometry, Point inputPoint) {
        OperatorProximity2D proximity = (OperatorProximity2D)factory.getOperator(Operator.Type.Proximity2D);
        Proximity2DResult result = proximity.getNearestVertex(geometry, inputPoint);
        return result;
    }

    public static Proximity2DResult[] getNearestVertices(Geometry geometry, Point inputPoint, double searchRadius, int maxVertexCountToReturn) {
        OperatorProximity2D proximity = (OperatorProximity2D)factory.getOperator(Operator.Type.Proximity2D);
        Proximity2DResult[] results = proximity.getNearestVertices(geometry, inputPoint, searchRadius, maxVertexCountToReturn);
        return results;
    }

    public static Geometry simplify(Geometry geometry, SpatialReference spatialReference) {
        OperatorSimplify op = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
        Geometry result = op.execute(geometry, spatialReference, false, null);
        return result;
    }

    static boolean isSimple(Geometry geometry, SpatialReference spatialReference) {
        OperatorSimplify op = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
        boolean result = op.isSimpleAsFeature(geometry, spatialReference, null);
        return result;
    }

    public static double geodesicDistanceOnWGS84(Point ptFrom, Point ptTo) {
        return SpatialReferenceImpl.geodesicDistanceOnWGS84Impl(ptFrom, ptTo);
    }
}

