/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;

@Description(value="Returns a geometry that represents the point set union of the input geometries.")
@AggregationFunction(value="geometry_union_agg")
public final class GeometryUnionAgg {
    private GeometryUnionAgg() {
    }

    @InputFunction
    public static void input(@AggregationState GeometryState state, @SqlType(value="Geometry") Slice input) {
        OGCGeometry geometry = GeometrySerde.deserialize((Slice)input);
        if (state.getGeometry() == null) {
            state.setGeometry(geometry);
        } else if (!geometry.isEmpty()) {
            state.setGeometry(state.getGeometry().union(geometry));
        }
    }

    @CombineFunction
    public static void combine(@AggregationState GeometryState state, @AggregationState GeometryState otherState) {
        if (state.getGeometry() == null) {
            state.setGeometry(otherState.getGeometry());
        } else if (otherState.getGeometry() != null && !otherState.getGeometry().isEmpty()) {
            state.setGeometry(state.getGeometry().union(otherState.getGeometry()));
        }
    }

    @OutputFunction(value="Geometry")
    public static void output(@AggregationState GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, GeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }
}

