/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.google.common.base.Joiner;
import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import java.util.Set;

@Description(value="Returns a geometry that is the convex hull of all the geometries in the set.")
@AggregationFunction(value="convex_hull_agg")
public final class ConvexHullAggregation {
    private static final Joiner OR_JOINER = Joiner.on((String)" or ");

    private ConvexHullAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState GeometryState state, @SqlType(value="Geometry") Slice input) {
        OGCGeometry geometry = GeometrySerde.deserialize((Slice)input);
        if (state.getGeometry() == null) {
            state.setGeometry(geometry.convexHull());
        } else if (!geometry.isEmpty()) {
            state.setGeometry(state.getGeometry().union(geometry).convexHull());
        }
    }

    @CombineFunction
    public static void combine(@AggregationState GeometryState state, @AggregationState GeometryState otherState) {
        if (state.getGeometry() == null) {
            state.setGeometry(otherState.getGeometry());
        } else if (otherState.getGeometry() != null && !otherState.getGeometry().isEmpty()) {
            state.setGeometry(state.getGeometry().union(otherState.getGeometry()).convexHull());
        }
    }

    @OutputFunction(value="Geometry")
    public static void output(@AggregationState GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, GeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }

    private static void validateType(String function, OGCGeometry geometry, Set<io.trino.geospatial.GeometryType> validTypes) {
        io.trino.geospatial.GeometryType type = io.trino.geospatial.GeometryType.getForEsriGeometryType((String)geometry.geometryType());
        if (!validTypes.contains(type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%s only applies to %s. Input type is: %s", function, OR_JOINER.join(validTypes), type));
        }
    }
}

