/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

public class GcsFileSystemConfig {
    private DataSize readBlockSize = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize writeBlockSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int pageSize = 100;
    private int batchSize = 100;
    private String projectId;
    private boolean useGcsAccessToken;
    private String jsonKey;
    private String jsonKeyFilePath;

    @NotNull
    public DataSize getReadBlockSize() {
        return this.readBlockSize;
    }

    @Config(value="gcs.read-block-size")
    @ConfigDescription(value="Minimum size that will be read in one RPC. The default size is 2MiB, see com.google.cloud.BaseStorageReadChannel.")
    public GcsFileSystemConfig setReadBlockSize(DataSize readBlockSize) {
        this.readBlockSize = readBlockSize;
        return this;
    }

    @NotNull
    public DataSize getWriteBlockSize() {
        return this.writeBlockSize;
    }

    @Config(value="gcs.write-block-size")
    @ConfigDescription(value="Minimum size that will be written in one RPC. The default size is 16MiB, see com.google.cloud.BaseStorageWriteChannel.")
    public GcsFileSystemConfig setWriteBlockSize(DataSize writeBlockSize) {
        this.writeBlockSize = writeBlockSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPageSize() {
        return this.pageSize;
    }

    @Config(value="gcs.page-size")
    @ConfigDescription(value="The maximum number of blobs to return per page.")
    public GcsFileSystemConfig setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getBatchSize() {
        return this.batchSize;
    }

    @Config(value="gcs.batch-size")
    @ConfigDescription(value="Number of blobs to delete per batch. Recommended batch size is 100: https://cloud.google.com/storage/docs/batch")
    public GcsFileSystemConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Config(value="gcs.project-id")
    public GcsFileSystemConfig setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public boolean isUseGcsAccessToken() {
        return this.useGcsAccessToken;
    }

    @Config(value="gcs.use-access-token")
    public GcsFileSystemConfig setUseGcsAccessToken(boolean useGcsAccessToken) {
        this.useGcsAccessToken = useGcsAccessToken;
        return this;
    }

    @Nullable
    public String getJsonKey() {
        return this.jsonKey;
    }

    @Config(value="gcs.json-key")
    @ConfigSecuritySensitive
    public GcsFileSystemConfig setJsonKey(String jsonKey) {
        this.jsonKey = jsonKey;
        return this;
    }

    @Nullable
    @FileExists
    public String getJsonKeyFilePath() {
        return this.jsonKeyFilePath;
    }

    @Config(value="gcs.json-key-file-path")
    @ConfigDescription(value="JSON key file used to access Google Cloud Storage")
    public GcsFileSystemConfig setJsonKeyFilePath(String jsonKeyFilePath) {
        this.jsonKeyFilePath = jsonKeyFilePath;
        return this;
    }

    public void validate() {
        if (this.useGcsAccessToken) {
            Preconditions.checkState((this.jsonKey == null ? 1 : 0) != 0, (Object)"Cannot specify 'hive.gcs.json-key' when 'hive.gcs.use-access-token' is set");
            Preconditions.checkState((this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"Cannot specify 'hive.gcs.json-key-file-path' when 'hive.gcs.use-access-token' is set");
        }
        Preconditions.checkState((this.jsonKey == null || this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"'hive.gcs.json-key' and 'hive.gcs.json-key-file-path' cannot be both set");
    }
}

