/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.google.inject.Inject;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureAuthOAuthConfig;

public class AzureAuthOauth
implements AzureAuth {
    private final ClientSecretCredential credential;

    @Inject
    public AzureAuthOauth(AzureAuthOAuthConfig config) {
        this(config.getClientEndpoint(), config.getClientId(), config.getClientSecret());
    }

    public AzureAuthOauth(String clientEndpoint, String clientId, String clientSecret) {
        this.credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().authorityHost(clientEndpoint)).clientId(clientId)).clientSecret(clientSecret).build();
    }

    @Override
    public void setAuth(String storageAccount, BlobContainerClientBuilder builder) {
        builder.credential((TokenCredential)this.credential);
    }

    @Override
    public void setAuth(String storageAccount, DataLakeServiceClientBuilder builder) {
        builder.credential((TokenCredential)this.credential);
    }
}

