/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;

public class FileDiff
extends AbstractINodeDiff<INodeFile, INodeFileAttributes, FileDiff> {
    private final long fileSize;
    private BlockInfo[] blocks;

    FileDiff(int snapshotId, INodeFile file) {
        super(snapshotId, null, null);
        this.fileSize = file.computeFileSize();
        this.blocks = null;
    }

    FileDiff(int snapshotId, INodeFileAttributes snapshotINode, FileDiff posteriorDiff, long fileSize) {
        super(snapshotId, snapshotINode, posteriorDiff);
        this.fileSize = fileSize;
        this.blocks = null;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setBlocks(BlockInfo[] blocks) {
        if (this.blocks != null) {
            return;
        }
        int numBlocks = 0;
        for (long s2 = 0L; numBlocks < blocks.length && s2 < this.fileSize; s2 += blocks[numBlocks].getNumBytes(), ++numBlocks) {
        }
        this.blocks = Arrays.copyOf(blocks, numBlocks);
    }

    public BlockInfo[] getBlocks() {
        return this.blocks;
    }

    @Override
    void combinePosteriorAndCollectBlocks(INode.ReclaimContext reclaimContext, INodeFile currentINode, FileDiff posterior) {
        FileWithSnapshotFeature sf = currentINode.getFileWithSnapshotFeature();
        assert (sf != null) : "FileWithSnapshotFeature is null";
        sf.updateQuotaAndCollectBlocks(reclaimContext, currentINode, posterior);
    }

    @Override
    public String toString() {
        return super.toString() + " fileSize=" + this.fileSize + ", rep=" + (this.snapshotINode == null ? "?" : Short.valueOf(((INodeFileAttributes)this.snapshotINode).getFileReplication()));
    }

    @Override
    void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        this.writeSnapshot(out);
        out.writeLong(this.fileSize);
        if (this.snapshotINode != null) {
            out.writeBoolean(true);
            FSImageSerialization.writeINodeFileAttributes((INodeFileAttributes)this.snapshotINode, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    void destroyDiffAndCollectBlocks(INode.ReclaimContext reclaimContext, INodeFile currentINode) {
        currentINode.getFileWithSnapshotFeature().updateQuotaAndCollectBlocks(reclaimContext, currentINode, this);
    }

    public void destroyAndCollectSnapshotBlocks(INode.BlocksMapUpdateInfo collectedBlocks) {
        if (this.blocks == null || collectedBlocks == null) {
            return;
        }
        for (BlockInfo blk : this.blocks) {
            collectedBlocks.addDeleteBlock(blk);
        }
        this.blocks = null;
    }
}

