/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import java.io.Closeable;
import java.util.Objects;

public class SetThreadName
implements Closeable {
    private final String originalThreadName;

    public SetThreadName(String format, Object ... args) {
        Objects.requireNonNull(format, "format is null");
        this.originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format(format, args) + "-" + SetThreadName.getThreadId(Thread.currentThread()));
    }

    public static long getThreadId(Thread thread) {
        return thread.getId();
    }

    @Override
    public void close() {
        Thread.currentThread().setName(this.originalThreadName);
    }
}

