/*
 * Decompiled with CFR 0.152.
 */
package io.trino.matching;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.DefaultPrinter;
import io.trino.matching.Match;
import io.trino.matching.PatternVisitor;
import io.trino.matching.Property;
import io.trino.matching.PropertyPattern;
import io.trino.matching.pattern.CapturePattern;
import io.trino.matching.pattern.FilterPattern;
import io.trino.matching.pattern.TypeOfPattern;
import io.trino.matching.pattern.WithPattern;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class Pattern<T> {
    private final Optional<Pattern<?>> previous;

    public static Pattern<Object> any() {
        return Pattern.typeOf(Object.class);
    }

    public static <T> Pattern<T> typeOf(Class<T> expectedClass) {
        return new TypeOfPattern<T>(expectedClass);
    }

    protected Pattern(Pattern<?> previous) {
        this(Optional.of(Objects.requireNonNull(previous, "previous is null")));
    }

    protected Pattern(Optional<Pattern<?>> previous) {
        this.previous = Objects.requireNonNull(previous, "previous is null");
    }

    public static <F, C, T extends Iterable<S>, S> PropertyPattern<F, C, T> empty(Property<F, C, T> property) {
        return PropertyPattern.upcast(property.matching(Iterables::isEmpty));
    }

    public static <F, C, T extends Iterable<S>, S> PropertyPattern<F, C, T> nonEmpty(Property<F, C, T> property) {
        return PropertyPattern.upcast(property.matching((Predicate<T>)Predicates.not(Iterables::isEmpty)));
    }

    public Pattern<T> capturedAs(Capture<T> capture) {
        return new CapturePattern<T>(capture, this);
    }

    public Pattern<T> matching(Predicate<? super T> predicate) {
        return this.matching((? super T t, ? context) -> predicate.test(t));
    }

    public Pattern<T> matching(BiPredicate<? super T, ?> predicate) {
        return new FilterPattern<T>(predicate, Optional.of(this));
    }

    public Pattern<T> with(PropertyPattern<? super T, ?, ?> pattern) {
        return new WithPattern<T>(pattern, this);
    }

    public Optional<Pattern<?>> previous() {
        return this.previous;
    }

    public abstract <C> Stream<Match> accept(Object var1, Captures var2, C var3);

    public abstract void accept(PatternVisitor var1);

    public <C> boolean matches(Object object, C context) {
        return this.match(object, context).findFirst().isPresent();
    }

    public final Stream<Match> match(Object object) {
        return this.match(object, Captures.empty(), null);
    }

    public final <C> Stream<Match> match(Object object, C context) {
        return this.match(object, Captures.empty(), context);
    }

    public final <C> Stream<Match> match(Object object, Captures captures, C context) {
        if (this.previous.isPresent()) {
            return this.previous.get().match(object, captures, context).flatMap(match -> this.accept(object, match.captures(), context));
        }
        return this.accept(object, captures, context);
    }

    public String toString() {
        DefaultPrinter printer = new DefaultPrinter();
        this.accept(printer);
        return printer.result();
    }
}

