/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.errorprone.annotations.FormatMethod;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Objects;
import java.util.logging.Level;

public class Logger {
    private final java.util.logging.Logger logger;

    Logger(java.util.logging.Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public static Logger get(Class<?> clazz) {
        return Logger.get(clazz.getName());
    }

    public static Logger get(String name) {
        return new Logger(java.util.logging.Logger.getLogger(name));
    }

    public void debug(Throwable exception, String message) {
        this.logger.log(Level.FINE, message, exception);
    }

    public void debug(String message) {
        this.logger.log(Level.FINE, message);
    }

    @FormatMethod
    public void debug(String format, Object ... args) {
        this.debug(null, format, args);
    }

    @FormatMethod
    public void debug(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, this.formatMessage(format, "DEBUG", args), exception);
        }
    }

    public void info(String message) {
        this.logger.log(Level.INFO, message);
    }

    @FormatMethod
    public void info(String format, Object ... args) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, this.formatMessage(format, "INFO", args));
        }
    }

    public void warn(Throwable exception, String message) {
        this.logger.log(Level.WARNING, message, exception);
    }

    public void warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @FormatMethod
    public void warn(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, this.formatMessage(format, "WARN", args), exception);
        }
    }

    @FormatMethod
    public void warn(String format, Object ... args) {
        this.warn(null, format, args);
    }

    public void error(Throwable exception, String message) {
        this.logger.log(Level.SEVERE, message, exception);
    }

    public void error(String message) {
        this.logger.severe(message);
    }

    @FormatMethod
    public void error(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.log(Level.SEVERE, this.formatMessage(format, "ERROR", args), exception);
        }
    }

    public void error(Throwable exception) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @FormatMethod
    public void error(String format, Object ... args) {
        this.error(null, format, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    private String formatMessage(String format, String level, Object[] args) {
        String message;
        try {
            message = String.format(format, args);
        }
        catch (IllegalFormatException e) {
            this.logger.log(Level.SEVERE, String.format("Invalid format string while trying to log: %s '%s' %s", level, format, Arrays.asList(args)), e);
            message = String.format("'%s' %s", format, Arrays.asList(args));
        }
        return message;
    }
}

